/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.WebSocketContainer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientSocket;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyWriter;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.WebSocketResponse;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

class GrizzlyClientFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(GrizzlyClientFilter.class);
    private static final Attribute<org.glassfish.tyrus.spi.Connection> TYRUS_CONNECTION = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyClientFilter.class.getName() + ".Connection");
    static final Attribute<TyrusWebSocketEngine.WebSocketHolder> WEB_SOCKET_HOLDER = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(TyrusWebSocketEngine.WebSocketHolder.class.getName());
    private final boolean proxy;
    private final Filter sslFilter;
    private final WebSocketEngine engine;
    private final WebSocketContainer webSocketContainer;
    private final Deque<Task> taskDeque = new ConcurrentLinkedDeque<Task>();
    private UpgradeRequest webSocketRequest;

    public GrizzlyClientFilter(WebSocketEngine engine, WebSocketContainer webSocketContainer) {
        this(engine, webSocketContainer, false);
    }

    public GrizzlyClientFilter(WebSocketEngine engine, WebSocketContainer webSocketContainer, boolean proxy) {
        this(engine, webSocketContainer, proxy, null);
    }

    public GrizzlyClientFilter(WebSocketEngine engine, WebSocketContainer webSocketContainer, boolean proxy, Filter sslFilter) {
        this.engine = engine;
        this.webSocketContainer = webSocketContainer;
        this.proxy = proxy;
        this.sslFilter = sslFilter;
    }

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        logger.log(Level.FINEST, "handleConnect");
        TyrusWebSocketEngine.WebSocketHolder webSocketHolder = (TyrusWebSocketEngine.WebSocketHolder)WEB_SOCKET_HOLDER.get((AttributeStorage)ctx.getConnection());
        this.webSocketRequest = webSocketHolder.handshake.initiate();
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
        if (this.proxy) {
            URI requestURI = URI.create(this.webSocketRequest.getRequestUri());
            int requestPort = requestURI.getPort() == -1 ? (requestURI.getScheme().equals("wss") ? 443 : 80) : requestURI.getPort();
            builder = builder.uri(String.format("%s:%d", requestURI.getHost(), requestPort));
            builder = (HttpRequestPacket.Builder)builder.protocol(Protocol.HTTP_1_1);
            builder = builder.method(Method.CONNECT);
            builder = (HttpRequestPacket.Builder)builder.header(Header.Host, requestURI.getHost());
            builder = (HttpRequestPacket.Builder)builder.header(Header.ProxyConnection, "keep-alive");
            builder = (HttpRequestPacket.Builder)builder.header(Header.Connection, "keep-alive");
            ctx.write((Object)HttpContent.builder((HttpHeader)builder.build()).build());
            ctx.flush(null);
        } else {
            ctx.write((Object)this.getHttpContent(this.webSocketRequest));
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        org.glassfish.tyrus.spi.Connection connection = this.getConnection(ctx);
        if (connection != null) {
            this.taskDeque.addLast(new CloseTask(connection, new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, null), ctx.getConnection()));
            this.processDeque(connection);
        }
        return ctx.getStopAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        HttpContent message = (HttpContent)ctx.getMessage();
        org.glassfish.tyrus.spi.Connection tyrusConnection = this.getConnection(ctx);
        HttpHeader header = message.getHttpHeader();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{tyrusConnection, message.getContent().remaining(), header});
        }
        if (tyrusConnection != null) {
            HttpStatus httpStatus = ((HttpResponsePacket)message.getHttpHeader()).getHttpStatus();
            if (httpStatus != HttpStatus.SWITCHING_PROTOCOLS_101 && this.proxy) {
                if (httpStatus == HttpStatus.OK_200) {
                    if (this.sslFilter != null) {
                        ((GrizzlyClientSocket.FilterWrapper)this.sslFilter).enable();
                    }
                } else {
                    throw new HandshakeException(String.format("Proxy error. %s: %s", httpStatus.getStatusCode(), new String(httpStatus.getReasonPhraseBytes(), "UTF-8")));
                }
                ctx.write((Object)this.getHttpContent(this.webSocketRequest));
                return ctx.getInvokeAction();
            }
            if (message.getContent().hasRemaining()) {
                Buffer buffer = message.getContent();
                ByteBuffer webSocketBuffer = buffer.toByteBuffer();
                message.recycle();
                ReadHandler readHandler = tyrusConnection.getReadHandler();
                this.taskDeque.addLast(new ProcessTask(webSocketBuffer, readHandler));
                this.processDeque(tyrusConnection);
            }
            return ctx.getStopAction();
        }
        if (!"websocket".equalsIgnoreCase(header.getUpgrade()) && message.getHttpHeader().isRequest()) {
            return ctx.getInvokeAction();
        }
        String ATTR_NAME = "org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED";
        AttributeHolder attributeHolder = ctx.getAttributes();
        if (attributeHolder != null) {
            Object attribute = attributeHolder.getAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED");
            if (attribute != null) {
                return ctx.getInvokeAction();
            }
            attributeHolder.setAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED", (Object)true);
        }
        return this.handleHandshake(ctx, message);
    }

    private org.glassfish.tyrus.spi.Connection getConnection(FilterChainContext ctx) {
        return (org.glassfish.tyrus.spi.Connection)TYRUS_CONNECTION.get((AttributeStorage)ctx.getConnection());
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) throws IOException {
        final GrizzlyWriter grizzlyWriter = this.getWebSocketConnection(ctx);
        final TyrusWebSocketEngine.WebSocketHolder holder = (TyrusWebSocketEngine.WebSocketHolder)WEB_SOCKET_HOLDER.get((AttributeStorage)ctx.getConnection());
        if (holder == null) {
            content.recycle();
            return ctx.getStopAction();
        }
        try {
            WebSocketResponse upgradeResponse = GrizzlyClientFilter.getWebSocketResponse((HttpResponsePacket)content.getHttpHeader());
            holder.handshake.validateServerResponse((UpgradeResponse)upgradeResponse);
            holder.handshake.getResponseListener().onHandShakeResponse((UpgradeResponse)upgradeResponse);
            holder.webSocket.onConnect();
        }
        catch (HandshakeException e) {
            holder.handshake.getResponseListener().onError(e);
            content.getContent().clear();
            return ctx.getStopAction();
        }
        TYRUS_CONNECTION.set((AttributeStorage)ctx.getConnection(), (Object)new org.glassfish.tyrus.spi.Connection(){
            private final ReadHandler readHandler;
            {
                this.readHandler = ((TyrusWebSocketEngine)GrizzlyClientFilter.this.engine).getReadHandler(holder);
            }

            public ReadHandler getReadHandler() {
                return this.readHandler;
            }

            public Writer getWriter() {
                return grizzlyWriter;
            }

            public Connection.CloseListener getCloseListener() {
                return new Connection.CloseListener(){

                    public void close(CloseReason reason) {
                    }
                };
            }

            public void close(CloseReason reason) {
                grizzlyWriter.close();
            }
        });
        if (content.getContent().hasRemaining()) {
            return ctx.getRerunFilterAction();
        }
        content.recycle();
        return ctx.getStopAction();
    }

    private static WebSocketResponse getWebSocketResponse(HttpResponsePacket httpResponsePacket) {
        WebSocketResponse webSocketResponse = new WebSocketResponse();
        for (String name : httpResponsePacket.getHeaders().names()) {
            List values = (List)webSocketResponse.getHeaders().get(name);
            if (values == null) {
                webSocketResponse.getHeaders().put(name, Utils.parseHeaderValue((String)httpResponsePacket.getHeader(name)));
                continue;
            }
            values.addAll(Utils.parseHeaderValue((String)httpResponsePacket.getHeader(name)));
        }
        webSocketResponse.setStatus(httpResponsePacket.getStatus());
        return webSocketResponse;
    }

    private HttpContent getHttpContent(UpgradeRequest request) {
        HttpRequestPacket.Builder builder = HttpRequestPacket.builder();
        builder = (HttpRequestPacket.Builder)builder.protocol(Protocol.HTTP_1_1);
        builder = builder.method(Method.GET);
        StringBuilder sb = new StringBuilder();
        URI uri = URI.create(request.getRequestUri());
        sb.append(uri.getPath()).append('?').append(uri.getQuery());
        builder = builder.uri(sb.toString());
        for (Map.Entry headerEntry : request.getHeaders().entrySet()) {
            StringBuilder finalHeaderValue = new StringBuilder();
            for (String headerValue : (List)headerEntry.getValue()) {
                if (finalHeaderValue.length() != 0) {
                    finalHeaderValue.append(", ");
                }
                finalHeaderValue.append(headerValue);
            }
            builder.header((String)headerEntry.getKey(), finalHeaderValue.toString());
        }
        return HttpContent.builder((HttpHeader)builder.build()).build();
    }

    private GrizzlyWriter getWebSocketConnection(FilterChainContext ctx) {
        return new GrizzlyWriter(ctx.getConnection());
    }

    protected void processDeque(Object lock) {
        if (!this.taskDeque.isEmpty()) {
            do {
                Task first;
                if ((first = this.taskDeque.pollFirst()) == null) continue;
                first.execute();
            } while (!this.taskDeque.isEmpty());
        }
    }

    private class CloseTask
    extends Task {
        private final org.glassfish.tyrus.spi.Connection connection;
        private final CloseReason closeReason;
        private final Connection grizllyConnection;

        private CloseTask(org.glassfish.tyrus.spi.Connection connection, CloseReason closeReason, Connection grizzlyConnection) {
            this.connection = connection;
            this.closeReason = closeReason;
            this.grizllyConnection = grizzlyConnection;
        }

        @Override
        public void execute() {
            this.connection.close(this.closeReason);
            TYRUS_CONNECTION.remove((AttributeStorage)this.grizllyConnection);
        }
    }

    private class ProcessTask
    extends Task {
        private final ByteBuffer buffer;
        private final ReadHandler readHandler;

        private ProcessTask(ByteBuffer buffer, ReadHandler readHandler) {
            this.buffer = buffer;
            this.readHandler = readHandler;
        }

        @Override
        public void execute() {
            this.readHandler.handle(this.buffer);
        }
    }

    static abstract class Task {
        Task() {
        }

        public abstract void execute();
    }
}

