/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Extension;
import javax.websocket.SendHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientFilter;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyWriter;
import org.glassfish.tyrus.core.DataFrame;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusRemoteEndpoint;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.core.WebSocket;
import org.glassfish.tyrus.core.WebSocketListener;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.PingFrame;
import org.glassfish.tyrus.core.frame.PongFrame;
import org.glassfish.tyrus.spi.ClientContainer;
import org.glassfish.tyrus.spi.ClientSocket;
import org.glassfish.tyrus.spi.EndpointWrapper;
import org.glassfish.tyrus.spi.RemoteEndpoint;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

public class GrizzlyClientSocket
implements WebSocket,
ClientSocket {
    public static final String PROXY_URI = "org.glassfish.tyrus.client.proxy";
    public static final String WORKER_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.workerThreadPoolConfig";
    public static final String SELECTOR_THREAD_POOL_CONFIG = "org.glassfish.tyrus.client.grizzly.selectorThreadPoolConfig";
    private static final Logger LOGGER = Logger.getLogger(GrizzlyClientSocket.class.getName());
    private final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final List<Proxy> proxies = new ArrayList<Proxy>();
    private final List<Extension> responseExtensions = new ArrayList<Extension>();
    private final List<String> responseSubprotocol = new ArrayList<String>(1);
    private final CountDownLatch onConnectLatch = new CountDownLatch(1);
    private final URI uri;
    private final ProtocolHandler protocolHandler;
    private final EndpointWrapper endpoint;
    private final TyrusRemoteEndpoint remoteEndpoint;
    private final long timeoutMs;
    private final ClientEndpointConfig configuration;
    private final ClientContainer.ClientHandshakeListener listener;
    private final SSLEngineConfigurator clientSSLEngineConfigurator;
    private final ThreadPoolConfig workerThreadPoolConfig;
    private final ThreadPoolConfig selectorThreadPoolConfig;
    private final WebSocketEngine engine;
    private SocketAddress socketAddress;
    private TCPNIOTransport transport;
    private Session session = null;

    GrizzlyClientSocket(EndpointWrapper endpoint, URI uri, ClientEndpointConfig configuration, long timeoutMs, ClientContainer.ClientHandshakeListener listener, WebSocketEngine engine, SSLEngineConfigurator clientSSLEngineConfigurator, String proxyString, ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) {
        this.endpoint = endpoint;
        this.uri = uri;
        this.configuration = configuration;
        this.protocolHandler = TyrusWebSocketEngine.DEFAULT_VERSION.createHandler(true);
        this.protocolHandler.setContainer(endpoint.getWebSocketContainer());
        this.remoteEndpoint = new TyrusRemoteEndpoint((WebSocket)this);
        this.timeoutMs = timeoutMs;
        this.listener = listener;
        this.clientSSLEngineConfigurator = clientSSLEngineConfigurator;
        this.workerThreadPoolConfig = workerThreadPoolConfig;
        this.selectorThreadPoolConfig = selectorThreadPoolConfig;
        if (this.session == null) {
            this.session = endpoint.createSessionForRemoteEndpoint((RemoteEndpoint)this.remoteEndpoint, null, null);
        }
        this.engine = engine;
        this.setProxy(proxyString);
    }

    public void connect() throws DeploymentException, IOException {
        for (Proxy proxy : this.proxies) {
            GrizzlyFuture connectionGrizzlyFuture;
            try {
                this.transport = this.createTransport(this.workerThreadPoolConfig, this.selectorThreadPoolConfig);
                this.transport.start();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Transport failed to start.", e);
                throw e;
            }
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){

                protected void preConfigure(Connection conn) {
                    super.preConfigure(conn);
                    Writer writer = GrizzlyClientSocket.getConnection(conn);
                    GrizzlyClientSocket.this.protocolHandler.setWriter(writer);
                    TyrusWebSocketEngine.WebSocketHolder holder = new TyrusWebSocketEngine.WebSocketHolder(GrizzlyClientSocket.this.protocolHandler, (WebSocket)GrizzlyClientSocket.this, GrizzlyClientSocket.this.protocolHandler.createClientHandShake((UpgradeRequest)RequestContext.Builder.create().requestURI(GrizzlyClientSocket.this.uri).build()), null);
                    GrizzlyClientFilter.WEB_SOCKET_HOLDER.set((AttributeStorage)conn, (Object)holder);
                    GrizzlyClientSocket.this.prepareHandshake(holder.handshake);
                }
            };
            connectorHandler.setSyncConnectTimeout(this.timeoutMs, TimeUnit.MILLISECONDS);
            switch (proxy.type()) {
                case DIRECT: {
                    connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain(this.engine, this.endpoint.getWebSocketContainer(), null, this.clientSSLEngineConfigurator, false));
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' (no proxy).", this.uri));
                    connectionGrizzlyFuture = connectorHandler.connect(this.socketAddress);
                    break;
                }
                default: {
                    InetSocketAddress inetSocketAddress;
                    connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain(this.engine, this.endpoint.getWebSocketContainer(), null, this.clientSSLEngineConfigurator, true));
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' via proxy '%s'.", this.uri, proxy));
                    SocketAddress address = proxy.address();
                    if (address instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)address).isUnresolved()) {
                        address = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                    }
                    connectionGrizzlyFuture = connectorHandler.connect(address);
                }
            }
            try {
                Connection connection = (Connection)connectionGrizzlyFuture.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                LOGGER.log(Level.CONFIG, String.format("Connected to '%s'.", connection.getPeerAddress()));
                this.awaitOnConnect();
                return;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), interruptedException);
                this.closeTransport();
            }
            catch (TimeoutException timeoutException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), timeoutException);
                this.closeTransport();
            }
            catch (ExecutionException exectionException) {
                LOGGER.log(Level.CONFIG, String.format("Connection to '%s' failed.", this.uri), exectionException);
                IOException ioException = null;
                Throwable cause = exectionException.getCause();
                if (cause != null && cause instanceof IOException) {
                    ioException = (IOException)cause;
                    ProxySelector.getDefault().connectFailed(this.uri, this.socketAddress, ioException);
                }
                this.closeTransport();
                if (ioException == null) continue;
                throw ioException;
            }
        }
        throw new HandshakeException("Connection failed.");
    }

    private TCPNIOTransport createTransport(ThreadPoolConfig workerThreadPoolConfig, ThreadPoolConfig selectorThreadPoolConfig) {
        TCPNIOTransportBuilder transportBuilder = TCPNIOTransportBuilder.newInstance();
        if (workerThreadPoolConfig == null) {
            transportBuilder.setWorkerThreadPoolConfig(ThreadPoolConfig.defaultConfig().setMaxPoolSize(2).setCorePoolSize(2));
        } else {
            transportBuilder.setWorkerThreadPoolConfig(workerThreadPoolConfig);
        }
        if (selectorThreadPoolConfig == null) {
            transportBuilder.setSelectorThreadPoolConfig(ThreadPoolConfig.defaultConfig().setMaxPoolSize(1).setCorePoolSize(1));
        } else {
            transportBuilder.setSelectorThreadPoolConfig(selectorThreadPoolConfig);
        }
        transportBuilder.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
        return transportBuilder.build();
    }

    private void prepareHandshake(Handshake handshake) {
        handshake.setExtensions(this.configuration.getExtensions());
        handshake.setSubProtocols(this.configuration.getPreferredSubprotocols());
        handshake.setResponseListener(new Handshake.HandshakeResponseListener(){

            public void onHandShakeResponse(UpgradeResponse response) {
                List values = (List)response.getHeaders().get("Sec-WebSocket-Extensions");
                if (values != null) {
                    GrizzlyClientSocket.this.responseExtensions.addAll(TyrusExtension.fromString((List)values));
                }
                GrizzlyClientSocket.this.responseSubprotocol.add(response.getFirstHeaderValue("Sec-WebSocket-Protocol"));
                GrizzlyClientSocket.this.listener.onHandshakeResponse(response);
            }

            public void onError(HandshakeException exception) {
                GrizzlyClientSocket.this.listener.onError((Throwable)exception);
                GrizzlyClientSocket.this.onConnectLatch.countDown();
            }
        });
        handshake.prepareRequest();
        this.configuration.getConfigurator().beforeRequest(handshake.getRequest().getHeaders());
    }

    public Future<DataFrame> send(String s) {
        if (this.isConnected()) {
            return this.protocolHandler.send(s);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public void send(String data, SendHandler handler) {
        if (!this.isConnected()) {
            throw new RuntimeException("Socket is not connected.");
        }
        this.protocolHandler.send(data, handler);
    }

    public Future<DataFrame> send(byte[] bytes) {
        if (this.isConnected()) {
            return this.protocolHandler.send(bytes);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public void send(byte[] data, SendHandler handler) {
        if (!this.isConnected()) {
            throw new RuntimeException("Socket is not connected.");
        }
        this.protocolHandler.send(data, handler);
    }

    public Future<DataFrame> sendRawFrame(ByteBuffer data) {
        if (this.isConnected()) {
            return this.protocolHandler.sendRawFrame(data);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<DataFrame> sendPing(byte[] bytes) {
        if (this.isConnected()) {
            DataFrame df = new DataFrame((Frame)new PingFrame(), bytes);
            return this.protocolHandler.send(df, false);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<DataFrame> sendPong(byte[] bytes) {
        if (this.isConnected()) {
            DataFrame df = new DataFrame((Frame)new PongFrame(), bytes);
            return this.protocolHandler.send(df, false);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<DataFrame> stream(boolean b, String s) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(b, s);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<DataFrame> stream(boolean b, byte[] bytes, int i, int i1) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(b, bytes, i, i1);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public void close() {
        this.close(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), "Closing");
    }

    public Session getSession() {
        return this.session;
    }

    public void close(int i, String s) {
        CloseReason closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode((int)i), s);
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.endpoint.onClose((RemoteEndpoint)this.remoteEndpoint, closeReason);
            this.protocolHandler.close(i, s);
            this.closeTransport();
        }
        this.onClose(closeReason);
    }

    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    public void onConnect() {
        this.state.set(State.CONNECTED);
        this.endpoint.onConnect((RemoteEndpoint)this.remoteEndpoint, this.responseSubprotocol.get(0), this.responseExtensions);
        this.onConnectLatch.countDown();
    }

    public void onMessage(String message) {
        this.awaitOnConnect();
        this.endpoint.onMessage((RemoteEndpoint)this.remoteEndpoint, message);
    }

    public void onMessage(byte[] bytes) {
        this.awaitOnConnect();
        this.endpoint.onMessage((RemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(bytes));
    }

    public void onFragment(boolean b, String s) {
        this.awaitOnConnect();
        this.endpoint.onPartialMessage((RemoteEndpoint)this.remoteEndpoint, s, b);
    }

    public void onFragment(boolean bool, byte[] bytes) {
        this.awaitOnConnect();
        this.endpoint.onPartialMessage((RemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(bytes), bool);
    }

    public void onClose(CloseReason closeReason) {
        this.onConnectLatch.countDown();
        if (this.state.get() == State.CLOSED) {
            return;
        }
        if (!this.state.compareAndSet(State.CLOSING, State.CLOSED)) {
            this.endpoint.onClose((RemoteEndpoint)this.remoteEndpoint, closeReason);
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
            this.closeTransport();
        }
    }

    public void onPing(DataFrame dataFrame) {
        this.awaitOnConnect();
        this.endpoint.onPing((RemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(dataFrame.getBytes()));
    }

    public void onPong(DataFrame dataFrame) {
        this.awaitOnConnect();
        this.endpoint.onPong((RemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(dataFrame.getBytes()));
    }

    public boolean add(WebSocketListener webSocketListener) {
        throw new UnsupportedOperationException();
    }

    public void setWriteTimeout(long timeoutMs) {
        this.protocolHandler.setWriteTimeout(timeoutMs);
    }

    private void setProxy(String proxyString) {
        try {
            if (proxyString != null) {
                URI proxyUri = new URI(proxyString);
                if (proxyUri.getHost() == null) {
                    LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString));
                } else {
                    int proxyPort = proxyUri.getPort() == -1 ? 80 : proxyUri.getPort();
                    this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyPort)));
                }
            }
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString), e);
        }
        ProxySelector proxySelector = ProxySelector.getDefault();
        this.addProxies(proxySelector, this.uri, "socket", this.proxies);
        this.addProxies(proxySelector, this.uri, "https", this.proxies);
        this.addProxies(proxySelector, this.uri, "http", this.proxies);
        this.proxies.add(Proxy.NO_PROXY);
        int port = this.uri.getPort();
        if (port == -1) {
            String scheme = this.uri.getScheme();
            assert (scheme != null && (scheme.equals("ws") || scheme.equals("wss")));
            if (scheme.equals("ws")) {
                port = 80;
            } else if (scheme.equals("wss")) {
                port = 443;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format(String.format("Not using proxy for URI '%s'.", this.uri), new Object[0]));
        }
        this.socketAddress = new InetSocketAddress(this.uri.getHost(), port);
    }

    private void addProxies(ProxySelector proxySelector, URI uri, String scheme, List<Proxy> proxies) {
        for (Proxy p : proxySelector.select(this.getProxyUri(uri, scheme))) {
            switch (p.type()) {
                case HTTP: {
                    LOGGER.log(Level.FINE, String.format("Found proxy: '%s'", p));
                    proxies.add(p);
                    break;
                }
                case SOCKS: {
                    LOGGER.log(Level.INFO, String.format("Socks proxy is not supported, please file new issue at https://java.net/jira/browse/TYRUS. Proxy '%s' will be ignored.", p));
                    break;
                }
            }
        }
    }

    private URI getProxyUri(URI wsUri, String scheme) {
        try {
            return new URI(scheme, wsUri.getUserInfo(), wsUri.getHost(), wsUri.getPort(), wsUri.getPath(), wsUri.getQuery(), wsUri.getFragment());
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Exception during generating proxy URI '%s'", wsUri), e);
            return wsUri;
        }
    }

    private static Processor createFilterChain(WebSocketEngine engine, WebSocketContainer webSocketContainer, SSLEngineConfigurator serverSSLEngineConfigurator, SSLEngineConfigurator clientSSLEngineConfigurator, boolean proxy) {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        Object sslFilter = null;
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        if (serverSSLEngineConfigurator != null || clientSSLEngineConfigurator != null) {
            sslFilter = new SSLFilter(serverSSLEngineConfigurator, clientSSLEngineConfigurator);
            if (proxy) {
                sslFilter = new FilterWrapper((Filter)sslFilter);
            }
            clientFilterChainBuilder.add((Filter)sslFilter);
        }
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new GrizzlyClientFilter(engine, webSocketContainer, proxy, (Filter)sslFilter));
        return clientFilterChainBuilder.build();
    }

    private static Writer getConnection(Connection connection) {
        return new GrizzlyWriter(connection);
    }

    private void closeTransport() {
        if (this.transport != null) {
            try {
                this.transport.shutdownNow();
            }
            catch (IOException e) {
                Logger.getLogger(GrizzlyClientSocket.class.getName()).log(Level.FINE, "Transport closing problem.");
            }
        }
    }

    private void awaitOnConnect() {
        try {
            this.onConnectLatch.await(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class FilterWrapper
    implements Filter {
        private final Filter filter;
        private boolean enabled = false;

        FilterWrapper(Filter filter) {
            this.filter = filter;
        }

        public void enable() {
            this.enabled = true;
        }

        public void onAdded(FilterChain filterChain) {
            this.filter.onAdded(filterChain);
        }

        public void onRemoved(FilterChain filterChain) {
            this.filter.onRemoved(filterChain);
        }

        public void onFilterChainChanged(FilterChain filterChain) {
            this.filter.onFilterChainChanged(filterChain);
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleRead(ctx);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleWrite(ctx);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            return ctx.getInvokeAction();
        }

        public NextAction handleAccept(FilterChainContext ctx) throws IOException {
            return ctx.getInvokeAction();
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            if (this.enabled) {
                return this.filter.handleEvent(ctx, event);
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleClose(FilterChainContext ctx) throws IOException {
            if (this.enabled) {
                return this.filter.handleClose(ctx);
            }
            return ctx.getInvokeAction();
        }

        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            if (this.enabled) {
                this.filter.exceptionOccurred(ctx, error);
            } else {
                ctx.getInvokeAction();
            }
        }
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

