/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.client;

import java.nio.ByteBuffer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Writer;

public class GrizzlyWriter
extends Writer {
    private final Connection connection;

    public GrizzlyWriter(Connection connection) {
        this.connection = connection;
        this.connection.configureBlocking(false);
    }

    public void write(final ByteBuffer buffer, final CompletionHandler<ByteBuffer> completionHandler) {
        if (!this.connection.isOpen()) {
            completionHandler.failed((Throwable)new IllegalStateException("Connection is not open."));
            return;
        }
        Buffer message = Buffers.wrap((MemoryManager)this.connection.getTransport().getMemoryManager(), (ByteBuffer)buffer);
        EmptyCompletionHandler emptyCompletionHandler = new EmptyCompletionHandler(){

            public void cancelled() {
                if (completionHandler != null) {
                    completionHandler.cancelled();
                }
            }

            public void completed(Object result) {
                if (completionHandler != null) {
                    completionHandler.completed((Object)buffer);
                }
            }

            public void failed(Throwable throwable) {
                if (completionHandler != null) {
                    completionHandler.failed(throwable);
                }
            }
        };
        this.connection.write((Object)message, (org.glassfish.grizzly.CompletionHandler)emptyCompletionHandler);
    }

    public void close() {
        this.connection.closeSilently();
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GrizzlyWriter && this.connection.equals(((GrizzlyWriter)((Object)obj)).connection);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " " + this.connection.toString() + " " + this.connection.hashCode();
    }
}

