/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.server;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyWriter;
import org.glassfish.tyrus.container.grizzly.client.TaskProcessor;
import org.glassfish.tyrus.core.CloseReasons;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.ServerContainer;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

class GrizzlyServerFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(GrizzlyServerFilter.class);
    private static final Attribute<org.glassfish.tyrus.spi.Connection> TYRUS_CONNECTION = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyServerFilter.class.getName() + ".Connection");
    private final ServerContainer serverContainer;
    private final Queue<TaskProcessor.Task> taskQueue = new ConcurrentLinkedQueue<TaskProcessor.Task>();

    public GrizzlyServerFilter(ServerContainer serverContainer) {
        this.serverContainer = serverContainer;
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        org.glassfish.tyrus.spi.Connection connection = this.getConnection(ctx);
        if (connection != null) {
            this.taskQueue.add(new CloseTask(connection, CloseReasons.CLOSED_ABNORMALLY.getCloseReason(), ctx.getConnection()));
            TaskProcessor.processQueue(this.taskQueue, null);
        }
        return ctx.getStopAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        HttpContent message = (HttpContent)ctx.getMessage();
        org.glassfish.tyrus.spi.Connection tyrusConnection = this.getConnection(ctx);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{tyrusConnection, message.getContent().remaining(), message.getHttpHeader()});
        }
        if (tyrusConnection == null) {
            HttpHeader header = message.getHttpHeader();
            if (!"websocket".equalsIgnoreCase(header.getUpgrade()) && message.getHttpHeader().isRequest()) {
                return ctx.getInvokeAction();
            }
            String ATTR_NAME = "org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED";
            AttributeHolder attributeHolder = ctx.getAttributes();
            if (attributeHolder != null) {
                Object attribute = attributeHolder.getAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED");
                if (attribute != null) {
                    return ctx.getInvokeAction();
                }
                attributeHolder.setAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED", (Object)true);
            }
            return this.handleHandshake(ctx, message);
        }
        if (message.getContent().hasRemaining()) {
            Buffer buffer = message.getContent();
            message.recycle();
            ReadHandler readHandler = tyrusConnection.getReadHandler();
            if (!buffer.isComposite()) {
                this.taskQueue.add(new ProcessTask(buffer.toByteBuffer(), readHandler));
            } else {
                ByteBufferArray byteBufferArray = buffer.toByteBufferArray();
                ByteBuffer[] array = (ByteBuffer[])byteBufferArray.getArray();
                for (int i = 0; i < byteBufferArray.size(); ++i) {
                    this.taskQueue.add(new ProcessTask(array[i], readHandler));
                }
                byteBufferArray.recycle();
            }
            TaskProcessor.processQueue(this.taskQueue, null);
        }
        return ctx.getStopAction();
    }

    private org.glassfish.tyrus.spi.Connection getConnection(FilterChainContext ctx) {
        return (org.glassfish.tyrus.spi.Connection)TYRUS_CONNECTION.get((AttributeStorage)ctx.getConnection());
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) {
        UpgradeRequest upgradeRequest = GrizzlyServerFilter.createWebSocketRequest(content);
        TyrusUpgradeResponse upgradeResponse = new TyrusUpgradeResponse();
        WebSocketEngine.UpgradeInfo upgradeInfo = this.serverContainer.getWebSocketEngine().upgrade(upgradeRequest, (UpgradeResponse)upgradeResponse);
        switch (upgradeInfo.getStatus()) {
            case SUCCESS: {
                final Connection grizzlyConnection = ctx.getConnection();
                this.write(ctx, upgradeRequest, (UpgradeResponse)upgradeResponse);
                final org.glassfish.tyrus.spi.Connection connection = upgradeInfo.createConnection((Writer)new GrizzlyWriter(ctx.getConnection()), new Connection.CloseListener(){

                    public void close(CloseReason reason) {
                        grizzlyConnection.close();
                    }
                });
                TYRUS_CONNECTION.set((AttributeStorage)grizzlyConnection, (Object)connection);
                grizzlyConnection.addCloseListener(new CloseListener(){

                    public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                        connection.close(CloseReasons.GOING_AWAY.getCloseReason());
                        TYRUS_CONNECTION.remove((AttributeStorage)grizzlyConnection);
                    }
                });
                return ctx.getStopAction();
            }
            case HANDSHAKE_FAILED: {
                this.write(ctx, upgradeRequest, (UpgradeResponse)upgradeResponse);
                content.recycle();
                return ctx.getStopAction();
            }
            case NOT_APPLICABLE: {
                return ctx.getInvokeAction();
            }
        }
        return ctx.getStopAction();
    }

    private void write(FilterChainContext ctx, UpgradeRequest request, UpgradeResponse response) {
        HttpResponsePacket responsePacket = ((HttpRequestPacket)((HttpContent)ctx.getMessage()).getHttpHeader()).getResponse();
        responsePacket.setProtocol(Protocol.HTTP_1_1);
        responsePacket.setStatus(response.getStatus());
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            responsePacket.setHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
        ctx.write((Object)HttpContent.builder((HttpHeader)responsePacket).build());
    }

    private static UpgradeRequest createWebSocketRequest(HttpContent requestContent) {
        HttpRequestPacket requestPacket = (HttpRequestPacket)requestContent.getHttpHeader();
        RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(requestPacket.getRequestURI())).queryString(requestPacket.getQueryString()).secure(requestPacket.isSecure()).build();
        for (String name : requestPacket.getHeaders().names()) {
            List values = (List)requestContext.getHeaders().get(name);
            if (values == null) {
                requestContext.getHeaders().put(name, Utils.parseHeaderValue((String)requestPacket.getHeader(name).trim()));
                continue;
            }
            values.addAll(Utils.parseHeaderValue((String)requestPacket.getHeader(name).trim()));
        }
        return requestContext;
    }

    private class CloseTask
    extends TaskProcessor.Task {
        private final org.glassfish.tyrus.spi.Connection connection;
        private final CloseReason closeReason;
        private final Connection grizllyConnection;

        private CloseTask(org.glassfish.tyrus.spi.Connection connection, CloseReason closeReason, Connection grizzlyConnection) {
            this.connection = connection;
            this.closeReason = closeReason;
            this.grizllyConnection = grizzlyConnection;
        }

        public void execute() {
            this.connection.close(this.closeReason);
            TYRUS_CONNECTION.remove((AttributeStorage)this.grizllyConnection);
        }
    }

    private class ProcessTask
    extends TaskProcessor.Task {
        private final ByteBuffer buffer;
        private final ReadHandler readHandler;

        private ProcessTask(ByteBuffer buffer, ReadHandler readHandler) {
            this.buffer = buffer;
            this.readHandler = readHandler;
        }

        public void execute() {
            this.readHandler.handle(this.buffer);
        }
    }
}

