/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly.server;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyWriter;
import org.glassfish.tyrus.container.grizzly.client.TaskProcessor;
import org.glassfish.tyrus.core.CloseReasons;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.ServerContainer;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

class GrizzlyServerFilter
extends BaseFilter {
    private static final Logger LOGGER = Grizzly.logger(GrizzlyServerFilter.class);
    private static final Attribute<Connection> TYRUS_CONNECTION = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(GrizzlyServerFilter.class.getName() + ".Connection");
    private static final Attribute<TaskProcessor> TASK_PROCESSOR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(TaskProcessor.class.getName() + ".TaskProcessor");
    private final ServerContainer serverContainer;

    public GrizzlyServerFilter(ServerContainer serverContainer) {
        this.serverContainer = serverContainer;
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = this.getConnection(ctx);
        if (connection != null) {
            TaskProcessor taskProcessor = this.getTaskProcessor(ctx);
            taskProcessor.processTask((TaskProcessor.Task)new CloseTask(connection, CloseReasons.CLOSED_ABNORMALLY.getCloseReason(), ctx.getConnection()));
        }
        return ctx.getStopAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        HttpContent message = (HttpContent)ctx.getMessage();
        Connection tyrusConnection = this.getConnection(ctx);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{tyrusConnection, message.getContent().remaining(), message.getHttpHeader()});
        }
        if (tyrusConnection == null) {
            HttpHeader header = message.getHttpHeader();
            if (!"websocket".equalsIgnoreCase(header.getUpgrade()) && message.getHttpHeader().isRequest()) {
                return ctx.getInvokeAction();
            }
            String ATTR_NAME = "org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED";
            AttributeHolder attributeHolder = ctx.getAttributes();
            if (attributeHolder != null) {
                Object attribute = attributeHolder.getAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED");
                if (attribute != null) {
                    return ctx.getInvokeAction();
                }
                attributeHolder.setAttribute("org.glassfish.tyrus.container.grizzly.WebSocketFilter.HANDSHAKE_PROCESSED", (Object)true);
            }
            return this.handleHandshake(ctx, message);
        }
        if (message.getContent().hasRemaining()) {
            Buffer buffer = message.getContent();
            message.recycle();
            ReadHandler readHandler = tyrusConnection.getReadHandler();
            TaskProcessor taskProcessor = this.getTaskProcessor(ctx);
            if (!buffer.isComposite()) {
                taskProcessor.processTask((TaskProcessor.Task)new ProcessTask(buffer.toByteBuffer(), readHandler));
            } else {
                ByteBufferArray byteBufferArray = buffer.toByteBufferArray();
                ByteBuffer[] array = (ByteBuffer[])byteBufferArray.getArray();
                for (int i = 0; i < byteBufferArray.size(); ++i) {
                    taskProcessor.processTask((TaskProcessor.Task)new ProcessTask(array[i], readHandler));
                }
                byteBufferArray.recycle();
            }
        }
        return ctx.getStopAction();
    }

    private Connection getConnection(FilterChainContext ctx) {
        return (Connection)TYRUS_CONNECTION.get((AttributeStorage)ctx.getConnection());
    }

    private TaskProcessor getTaskProcessor(FilterChainContext ctx) {
        return (TaskProcessor)TASK_PROCESSOR.get((AttributeStorage)ctx.getConnection());
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) {
        UpgradeRequest upgradeRequest = GrizzlyServerFilter.createWebSocketRequest(content);
        TyrusUpgradeResponse upgradeResponse = new TyrusUpgradeResponse();
        WebSocketEngine.UpgradeInfo upgradeInfo = this.serverContainer.getWebSocketEngine().upgrade(upgradeRequest, (UpgradeResponse)upgradeResponse);
        switch (upgradeInfo.getStatus()) {
            case SUCCESS: {
                final org.glassfish.grizzly.Connection grizzlyConnection = ctx.getConnection();
                this.write(ctx, upgradeRequest, (UpgradeResponse)upgradeResponse);
                final Connection connection = upgradeInfo.createConnection((Writer)new GrizzlyWriter(ctx.getConnection()), new Connection.CloseListener(){

                    public void close(CloseReason reason) {
                        grizzlyConnection.close();
                    }
                });
                TYRUS_CONNECTION.set((AttributeStorage)grizzlyConnection, (Object)connection);
                TASK_PROCESSOR.set((AttributeStorage)grizzlyConnection, (Object)new TaskProcessor());
                grizzlyConnection.addCloseListener(new CloseListener(){

                    public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                        connection.close(CloseReasons.GOING_AWAY.getCloseReason());
                        TYRUS_CONNECTION.remove((AttributeStorage)grizzlyConnection);
                        TASK_PROCESSOR.remove((AttributeStorage)grizzlyConnection);
                    }
                });
                return ctx.getStopAction();
            }
            case HANDSHAKE_FAILED: {
                this.write(ctx, upgradeRequest, (UpgradeResponse)upgradeResponse);
                content.recycle();
                return ctx.getStopAction();
            }
            case NOT_APPLICABLE: {
                this.writeTraceHeaders(ctx, (UpgradeResponse)upgradeResponse);
                return ctx.getInvokeAction();
            }
        }
        return ctx.getStopAction();
    }

    private void write(FilterChainContext ctx, UpgradeRequest request, UpgradeResponse response) {
        HttpResponsePacket responsePacket = ((HttpRequestPacket)((HttpContent)ctx.getMessage()).getHttpHeader()).getResponse();
        responsePacket.setProtocol(Protocol.HTTP_1_1);
        responsePacket.setStatus(response.getStatus());
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            responsePacket.setHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
        ctx.write((Object)HttpContent.builder((HttpHeader)responsePacket).build());
    }

    private void writeTraceHeaders(FilterChainContext ctx, UpgradeResponse upgradeResponse) {
        HttpResponsePacket responsePacket = ((HttpRequestPacket)((HttpContent)ctx.getMessage()).getHttpHeader()).getResponse();
        for (Map.Entry entry : upgradeResponse.getHeaders().entrySet()) {
            if (!((String)entry.getKey()).contains("X-Tyrus-Tracing-")) continue;
            responsePacket.setHeader((String)entry.getKey(), Utils.getHeaderFromList((List)((List)entry.getValue())));
        }
    }

    private static UpgradeRequest createWebSocketRequest(HttpContent requestContent) {
        HttpRequestPacket requestPacket = (HttpRequestPacket)requestContent.getHttpHeader();
        RequestContext requestContext = RequestContext.Builder.create().requestURI(URI.create(requestPacket.getRequestURI())).queryString(requestPacket.getQueryString()).secure(requestPacket.isSecure()).remoteAddr(requestPacket.getRemoteAddress()).build();
        for (String name : requestPacket.getHeaders().names()) {
            for (String headerValue : requestPacket.getHeaders().values(name)) {
                List values = (List)requestContext.getHeaders().get(name);
                if (values == null) {
                    requestContext.getHeaders().put(name, Utils.parseHeaderValue((String)headerValue.trim()));
                    continue;
                }
                values.addAll(Utils.parseHeaderValue((String)headerValue.trim()));
            }
        }
        return requestContext;
    }

    private class CloseTask
    extends TaskProcessor.Task {
        private final Connection connection;
        private final CloseReason closeReason;
        private final org.glassfish.grizzly.Connection grizzlyConnection;

        private CloseTask(Connection connection, CloseReason closeReason, org.glassfish.grizzly.Connection grizzlyConnection) {
            this.connection = connection;
            this.closeReason = closeReason;
            this.grizzlyConnection = grizzlyConnection;
        }

        public void execute() {
            this.connection.close(this.closeReason);
            TYRUS_CONNECTION.remove((AttributeStorage)this.grizzlyConnection);
            TASK_PROCESSOR.remove((AttributeStorage)this.grizzlyConnection);
        }
    }

    private class ProcessTask
    extends TaskProcessor.Task {
        private final ByteBuffer buffer;
        private final ReadHandler readHandler;

        private ProcessTask(ByteBuffer buffer, ReadHandler readHandler) {
            this.buffer = buffer;
            this.readHandler = readHandler;
        }

        public void execute() {
            this.readHandler.handle(this.buffer);
        }
    }
}

