/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.grizzly;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.websocket.RemoteEndpoint;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.glassfish.tyrus.grizzly.GrizzlyHandshakeRequest;
import org.glassfish.tyrus.grizzly.GrizzlyRemoteEndpoint;
import org.glassfish.tyrus.grizzly.GrizzlySocket;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;

class GrizzlyEndpoint
extends WebSocketApplication
implements SPIRegisteredEndpoint {
    private final SPIEndpoint endpoint;
    private List<String> temporaryNegotiatedExtensions;
    private String temporaryNegotiatedProtocol;

    GrizzlyEndpoint(SPIEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isApplicationRequest(HttpRequestPacket o) {
        List<String> protocols = this.createList(o.getHeader("Sec-WebSocket-Protocol"));
        this.temporaryNegotiatedProtocol = this.endpoint.getNegotiatedProtocol(protocols);
        List<String> extensions = this.createList(o.getHeader("Sec-WebSocket-Extensions"));
        this.temporaryNegotiatedExtensions = this.endpoint.getNegotiatedExtensions(extensions);
        return this.endpoint.checkHandshake((SPIHandshakeRequest)new GrizzlyHandshakeRequest(o));
    }

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        return new GrizzlySocket(handler, requestPacket, listeners);
    }

    public void onConnect(WebSocket socket) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        this.endpoint.onConnect((RemoteEndpoint)gs, this.temporaryNegotiatedProtocol, this.temporaryNegotiatedExtensions);
    }

    public void onFragment(WebSocket socket, String fragment, boolean last) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        try {
            this.endpoint.onPartialMessage((RemoteEndpoint)gs, fragment, last);
        }
        catch (Throwable t) {
            System.out.println("ERROR !!" + t);
            t.printStackTrace();
        }
    }

    public void onFragment(WebSocket socket, byte[] fragment, boolean last) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        try {
            this.endpoint.onPartialMessage((RemoteEndpoint)gs, ByteBuffer.wrap(fragment), last);
        }
        catch (Throwable t) {
            System.out.println("ERROR !!" + t);
            t.printStackTrace();
        }
    }

    public void onMessage(WebSocket socket, String messageString) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        this.endpoint.onMessage((RemoteEndpoint)gs, messageString);
    }

    public void onMessage(WebSocket socket, byte[] bytes) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        this.endpoint.onMessage((RemoteEndpoint)gs, ByteBuffer.wrap(bytes));
    }

    public void onClose(WebSocket socket, DataFrame frame) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        this.endpoint.onClose((RemoteEndpoint)gs);
        GrizzlyRemoteEndpoint.remove(socket);
    }

    public void onPong(WebSocket socket, byte[] bytes) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        this.endpoint.onPong((RemoteEndpoint)gs, ByteBuffer.wrap(bytes));
    }

    public void remove() {
        this.endpoint.remove();
    }

    public List<String> getSupportedExtensions() {
        return this.temporaryNegotiatedExtensions;
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        List<String> result;
        if (this.temporaryNegotiatedProtocol == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            result.add(this.temporaryNegotiatedProtocol);
        }
        return result;
    }

    private List<String> createList(String input) {
        if (input == null) {
            List<String> result = Collections.emptyList();
            return result;
        }
        String delimiter = ",";
        String[] tokens = input.split(delimiter);
        return Arrays.asList(tokens);
    }
}

