/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.grizzly;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.websocket.ClientEndpointConfiguration;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.tyrus.grizzly.GrizzlyClientSocket;
import org.glassfish.tyrus.grizzly.GrizzlyEndpoint;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;
import org.glassfish.tyrus.spi.TyrusServer;

public class GrizzlyEngine
implements TyrusContainer {
    private final WebSocketEngine engine = WebSocketEngine.getEngine();

    public TyrusServer createServer(String rootPath, int port) {
        final HttpServer server = HttpServer.createSimpleServer((String)rootPath, (int)port);
        server.getListener("grizzly").registerAddOn((AddOn)new WebSocketAddOn());
        return new TyrusServer(){

            public void start() throws IOException {
                server.start();
            }

            public void stop() {
                server.stop();
            }

            public SPIRegisteredEndpoint register(SPIEndpoint endpoint) {
                GrizzlyEndpoint ge = new GrizzlyEndpoint(endpoint);
                GrizzlyEngine.this.engine.register((WebSocketApplication)ge);
                return ge;
            }

            public void unregister(SPIRegisteredEndpoint ge) {
                GrizzlyEngine.this.engine.unregister((WebSocketApplication)((GrizzlyEndpoint)ge));
            }
        };
    }

    public TyrusClientSocket openClientSocket(String path, ClientEndpointConfiguration cec, SPIEndpoint endpoint) {
        URI uri;
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException e) {
            return null;
        }
        GrizzlyClientSocket clientSocket = new GrizzlyClientSocket(uri, cec, 1000L);
        clientSocket.addEndpoint(endpoint);
        clientSocket.connect();
        return clientSocket;
    }
}

