/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.tyrus.container.grizzly.ConnectionImpl;
import org.glassfish.tyrus.container.grizzly.WebSocketFilter;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.server.TyrusEndpoint;
import org.glassfish.tyrus.server.TyrusRemoteEndpoint;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.websockets.DataFrame;
import org.glassfish.tyrus.websockets.Extension;
import org.glassfish.tyrus.websockets.FrameType;
import org.glassfish.tyrus.websockets.HandShake;
import org.glassfish.tyrus.websockets.HandshakeException;
import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketEngine;
import org.glassfish.tyrus.websockets.WebSocketListener;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;
import org.glassfish.tyrus.websockets.frametypes.PingFrameType;
import org.glassfish.tyrus.websockets.frametypes.PongFrameType;

public class GrizzlyClientSocket
implements WebSocket,
TyrusClientSocket {
    private final URI uri;
    private final ProtocolHandler protocolHandler;
    private final Set<SPIEndpoint> endpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private TCPNIOTransport transport;
    private final EnumSet<State> connected = EnumSet.range(State.CONNECTED, State.CLOSING);
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final TyrusRemoteEndpoint remoteEndpoint;
    private final long timeoutMs;
    private final ClientEndpointConfig configuration;
    private Session session = null;
    private final List<Extension> responseExtensions = new ArrayList<Extension>();

    public GrizzlyClientSocket(URI uri, ClientEndpointConfig configuration, long timeoutMs) {
        this.uri = uri;
        this.configuration = configuration;
        this.protocolHandler = WebSocketEngine.DEFAULT_VERSION.createHandler(true);
        this.remoteEndpoint = new TyrusRemoteEndpoint((WebSocket)this);
        this.timeoutMs = timeoutMs;
    }

    public void connect() {
        try {
            this.transport = TCPNIOTransportBuilder.newInstance().build();
            this.transport.start();
            TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this.transport){

                protected void preConfigure(Connection conn) {
                    super.preConfigure(conn);
                    org.glassfish.tyrus.websockets.Connection connection = GrizzlyClientSocket.getConnection(conn);
                    GrizzlyClientSocket.this.protocolHandler.setConnection(connection);
                    WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().setWebSocketHolder(connection, GrizzlyClientSocket.this.protocolHandler, (WebSocket)GrizzlyClientSocket.this);
                    holder.handshake = GrizzlyClientSocket.this.protocolHandler.createHandShake(GrizzlyClientSocket.this.uri);
                    GrizzlyClientSocket.this.prepareHandshake(holder.handshake);
                }
            };
            connectorHandler.setProcessor(GrizzlyClientSocket.createFilterChain());
            int port = this.uri.getPort();
            if (port == -1) {
                String scheme = this.uri.getScheme();
                assert (scheme != null && (scheme.equals("ws") || scheme.equals("wss")));
                if (scheme.equals("ws")) {
                    port = 80;
                } else if (scheme.equals("wss")) {
                    port = 443;
                }
            }
            connectorHandler.connect((SocketAddress)new InetSocketAddress(this.uri.getHost(), port));
            connectorHandler.setSyncConnectTimeout(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HandshakeException(e.getMessage());
        }
    }

    private void prepareHandshake(HandShake handshake) {
        Object value;
        ArrayList<org.glassfish.tyrus.websockets.Extension> grizzlyExtensions = new ArrayList<org.glassfish.tyrus.websockets.Extension>();
        for (Extension e : this.configuration.getExtensions()) {
            org.glassfish.tyrus.websockets.Extension grizzlyExtension = new org.glassfish.tyrus.websockets.Extension(e.getName());
            for (Extension.Parameter p : e.getParameters()) {
                grizzlyExtension.getParameters().add(new Extension.Parameter(p.getName(), p.getValue()));
            }
            grizzlyExtensions.add(grizzlyExtension);
        }
        handshake.setExtensions(grizzlyExtensions);
        handshake.setSubProtocols(this.configuration.getPreferredSubprotocols());
        handshake.setResponseListener(new HandShake.HandShakeResponseListener(){

            public void onResponseHeaders(final Map<String, String> originalHeaders) {
                String value = originalHeaders.get("Sec-WebSocket-Extensions");
                if (value != null) {
                    GrizzlyClientSocket.this.responseExtensions.addAll(TyrusExtension.fromString((String)value));
                }
                GrizzlyClientSocket.this.configuration.getConfigurator().afterResponse(new HandshakeResponse(){
                    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.toLowerCase().compareTo(o2.toLowerCase());
                        }
                    });

                    public Map<String, List<String>> getHeaders() {
                        for (Map.Entry entry : originalHeaders.entrySet()) {
                            this.headers.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
                        }
                        return this.headers;
                    }
                });
            }
        });
        Map headers = handshake.composeRequest().getHeaders();
        HashMap adaptedHeaders = new HashMap();
        for (Map.Entry entry : headers.entrySet()) {
            value = (String)entry.getValue();
            adaptedHeaders.put(entry.getKey(), value == null ? null : Arrays.asList(value));
        }
        this.configuration.getConfigurator().beforeRequest(adaptedHeaders);
        headers.clear();
        for (Map.Entry entry : adaptedHeaders.entrySet()) {
            value = (List)entry.getValue();
            headers.put(entry.getKey(), value == null ? null : (String)value.get(0));
        }
    }

    public void addEndpoint(SPIEndpoint endpoint) {
        this.endpoints.add(endpoint);
        if (this.session == null) {
            this.session = endpoint.createSessionForRemoteEndpoint((SPIRemoteEndpoint)this.remoteEndpoint, null, null);
        }
    }

    public Future<DataFrame> send(String s) {
        if (this.isConnected()) {
            return this.protocolHandler.send(s);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<DataFrame> send(byte[] bytes) {
        if (this.isConnected()) {
            return this.protocolHandler.send(bytes);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<DataFrame> sendPing(byte[] bytes) {
        DataFrame df = new DataFrame((FrameType)new PingFrameType(), bytes);
        return this.protocolHandler.send(df);
    }

    public Future<DataFrame> sendPong(byte[] bytes) {
        DataFrame df = new DataFrame((FrameType)new PongFrameType(), bytes);
        return this.protocolHandler.send(df);
    }

    public Future<DataFrame> stream(boolean b, String s) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(b, s);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public Future<DataFrame> stream(boolean b, byte[] bytes, int i, int i1) {
        if (this.isConnected()) {
            return this.protocolHandler.stream(b, bytes, i, i1);
        }
        throw new RuntimeException("Socket is not connected.");
    }

    public void close() {
        this.close(100000, "Closing");
    }

    public Session getSession() {
        return this.session;
    }

    public void close(int i) {
        this.close(i, null);
    }

    public void close(int i, String s) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(i, s);
            if (this.transport != null) {
                try {
                    this.transport.stop();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isConnected() {
        return this.connected.contains((Object)this.state.get());
    }

    public void onConnect() {
        this.state.set(State.CONNECTED);
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onConnect((SPIRemoteEndpoint)this.remoteEndpoint, null, this.responseExtensions);
        }
    }

    public void onMessage(String message) {
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onMessage((SPIRemoteEndpoint)this.remoteEndpoint, message);
        }
    }

    public void onMessage(byte[] bytes) {
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onMessage((SPIRemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(bytes));
        }
    }

    public void onFragment(boolean b, String s) {
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onPartialMessage((SPIRemoteEndpoint)this.remoteEndpoint, s, b);
        }
    }

    public void onFragment(boolean bool, byte[] bytes) {
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onPartialMessage((SPIRemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(bytes), bool);
        }
    }

    public void onClose(ClosingFrame dataFrame) {
        if (this.state.compareAndSet(State.CONNECTED, State.CLOSING)) {
            this.protocolHandler.close(dataFrame.getCode(), dataFrame.getTextPayload());
        } else {
            this.state.set(State.CLOSED);
            this.protocolHandler.doClose();
        }
        for (SPIEndpoint endpoint : this.endpoints) {
            CloseReason closeReason = null;
            if (dataFrame != null) {
                closeReason = new CloseReason(TyrusEndpoint.getCloseCode((int)dataFrame.getCode()), dataFrame.getReason());
            }
            endpoint.onClose((SPIRemoteEndpoint)this.remoteEndpoint, closeReason);
        }
    }

    public void onPing(DataFrame dataFrame) {
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onPing((SPIRemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(dataFrame.getBytes()));
        }
    }

    public void onPong(DataFrame dataFrame) {
        for (SPIEndpoint endpoint : this.endpoints) {
            endpoint.onPong((SPIRemoteEndpoint)this.remoteEndpoint, ByteBuffer.wrap(dataFrame.getBytes()));
        }
    }

    public boolean add(WebSocketListener webSocketListener) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(WebSocketListener webSocketListener) {
        throw new UnsupportedOperationException();
    }

    private static Processor createFilterChain() {
        FilterChainBuilder clientFilterChainBuilder = FilterChainBuilder.stateless();
        clientFilterChainBuilder.add((Filter)new TransportFilter());
        clientFilterChainBuilder.add((Filter)new HttpClientFilter());
        clientFilterChainBuilder.add((Filter)new WebSocketFilter());
        return clientFilterChainBuilder.build();
    }

    private static org.glassfish.tyrus.websockets.Connection getConnection(Connection connection) {
        return new ConnectionImpl(connection);
    }

    static enum State {
        NEW,
        CONNECTED,
        CLOSING,
        CLOSED;

    }
}

