/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.grizzly;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.tyrus.container.grizzly.GrizzlyClientSocket;
import org.glassfish.tyrus.container.grizzly.WebSocketAddOn;
import org.glassfish.tyrus.server.TyrusEndpoint;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeListener;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;
import org.glassfish.tyrus.spi.TyrusServer;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketEngine;

public class GrizzlyEngine
implements TyrusContainer {
    public static final String SSL_ENGINE_CONFIGURATOR = "org.glassfish.tyrus.client.sslEngineConfigurator";
    private static final long CLIENT_SOCKET_TIMEOUT = 30000L;
    private final WebSocketEngine engine = WebSocketEngine.getEngine();

    public TyrusServer createServer(String rootPath, int port) {
        final HttpServer server = HttpServer.createSimpleServer((String)rootPath, (int)port);
        server.getListener("grizzly").registerAddOn((AddOn)new WebSocketAddOn());
        return new TyrusServer(){

            public void start() throws IOException {
                server.start();
            }

            public void stop() {
                server.stop();
            }

            public SPIRegisteredEndpoint register(SPIEndpoint endpoint) throws DeploymentException {
                TyrusEndpoint ge = new TyrusEndpoint(endpoint);
                GrizzlyEngine.this.engine.register((WebSocketApplication)ge);
                return ge;
            }

            public void unregister(SPIRegisteredEndpoint ge) {
                GrizzlyEngine.this.engine.unregister((WebSocketApplication)((TyrusEndpoint)ge));
            }
        };
    }

    public TyrusClientSocket openClientSocket(String url, ClientEndpointConfig cec, SPIEndpoint endpoint, SPIHandshakeListener listener, Map<String, Object> properties) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
        GrizzlyClientSocket clientSocket = new GrizzlyClientSocket(endpoint, uri, cec, 30000L, listener, properties == null ? null : (SSLEngineConfigurator)properties.get(SSL_ENGINE_CONFIGURATOR));
        clientSocket.connect();
        return clientSocket;
    }
}

