/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.inmemory;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.TyrusWebSocketEngine;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.ClientContainer;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

public class InMemoryClientContainer
implements ClientContainer {
    public static final String SERVER_CONFIG = "org.glassfish.tyrus.container.inmemory.ServerConfig";

    public void openClientSocket(ClientEndpointConfig cec, Map<String, Object> properties, ClientEngine clientEngine) throws DeploymentException, IOException {
        UpgradeRequest upgradeRequest = clientEngine.createUpgradeRequest(null);
        ServerApplicationConfig serverApplicationConfig = this.getServerApplicationConfig(cec);
        final TyrusServerContainer tyrusServerContainer = new TyrusServerContainer(serverApplicationConfig){
            private final WebSocketEngine webSocketEngine;
            private ClientManager clientManager;
            {
                this.webSocketEngine = TyrusWebSocketEngine.builder((WebSocketContainer)this).build();
                this.clientManager = null;
            }

            public void register(Class<?> endpointClass) throws DeploymentException {
                this.webSocketEngine.register(endpointClass, "/");
            }

            public void register(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
                this.webSocketEngine.register(serverEndpointConfig, "/");
            }

            public WebSocketEngine getWebSocketEngine() {
                return this.webSocketEngine;
            }

            protected synchronized ClientManager getClientManager() {
                if (this.clientManager == null) {
                    this.clientManager = ClientManager.createClient((String)InMemoryClientContainer.class.getName(), (WebSocketContainer)this);
                }
                return this.clientManager;
            }
        };
        tyrusServerContainer.doneDeployment();
        tyrusServerContainer.start("/inmemory", 0);
        TyrusUpgradeResponse upgradeResponse = new TyrusUpgradeResponse();
        StringBuilder sb = new StringBuilder();
        sb.append(upgradeRequest.getRequestURI().getPath());
        if (upgradeRequest.getRequestURI().getQuery() != null) {
            sb.append('?').append(upgradeRequest.getRequestURI().getQuery());
        }
        if (sb.length() == 0) {
            sb.append('/');
        }
        RequestContext requestContext = new RequestContext.Builder().requestURI(URI.create(sb.toString())).build();
        requestContext.getHeaders().putAll(upgradeRequest.getHeaders());
        WebSocketEngine.UpgradeInfo upgradeInfo = tyrusServerContainer.getWebSocketEngine().upgrade((UpgradeRequest)requestContext, (UpgradeResponse)upgradeResponse);
        switch (upgradeInfo.getStatus()) {
            case HANDSHAKE_FAILED: {
                tyrusServerContainer.shutdown();
                throw new DeploymentException("");
            }
            case NOT_APPLICABLE: {
                tyrusServerContainer.shutdown();
                throw new DeploymentException("");
            }
            case SUCCESS: {
                InMemoryWriter clientWriter = new InMemoryWriter(){

                    public void close() throws IOException {
                        tyrusServerContainer.shutdown();
                    }
                };
                InMemoryWriter serverWriter = new InMemoryWriter(){

                    public void close() throws IOException {
                        tyrusServerContainer.shutdown();
                    }
                };
                Connection serverConnection = upgradeInfo.createConnection((Writer)serverWriter, null);
                ClientEngine.ClientUpgradeInfo clientClientUpgradeInfo = clientEngine.processResponse((UpgradeResponse)upgradeResponse, (Writer)clientWriter, null);
                Connection clientConnection = clientClientUpgradeInfo.createConnection();
                if (clientConnection == null) {
                    throw new DeploymentException("");
                }
                serverWriter.setReadHandler(clientConnection.getReadHandler());
                clientWriter.setReadHandler(serverConnection.getReadHandler());
            }
        }
    }

    private ServerApplicationConfig getServerApplicationConfig(ClientEndpointConfig clientEndpointConfig) throws DeploymentException {
        Object o = clientEndpointConfig.getUserProperties().get(SERVER_CONFIG);
        if (o != null && o instanceof ServerApplicationConfig) {
            return (ServerApplicationConfig)o;
        }
        throw new DeploymentException("ServerApplicationConfig not present.");
    }

    private static abstract class InMemoryWriter
    extends Writer {
        private final List<ByteBuffer> cache = new ArrayList<ByteBuffer>();
        private volatile ReadHandler readHandler = null;

        private InMemoryWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ByteBuffer buffer, CompletionHandler<ByteBuffer> completionHandler) {
            List<ByteBuffer> list = this.cache;
            synchronized (list) {
                if (this.readHandler == null) {
                    this.cache.add(buffer);
                } else {
                    this.readHandler.handle(buffer);
                }
                completionHandler.completed((Object)buffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setReadHandler(ReadHandler readHandler) {
            List<ByteBuffer> list = this.cache;
            synchronized (list) {
                for (ByteBuffer buffer : this.cache) {
                    readHandler.handle(buffer);
                }
                this.readHandler = readHandler;
            }
        }
    }
}

