/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import org.glassfish.tyrus.container.jdk.client.Filter;
import org.glassfish.tyrus.container.jdk.client.HttpRequestBuilder;
import org.glassfish.tyrus.container.jdk.client.HttpResponseParser;
import org.glassfish.tyrus.container.jdk.client.JdkUpgradeRequest;
import org.glassfish.tyrus.container.jdk.client.ParseException;
import org.glassfish.tyrus.core.CloseReasons;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

class ClientFilter
extends Filter {
    private static final Logger LOGGER = Logger.getLogger(ClientFilter.class.getName());
    private final ClientEngine clientEngine;
    private final HttpResponseParser responseParser = new HttpResponseParser();
    private final Map<String, String> proxyHeaders;
    private final UpgradeRequest upgradeRequest;
    private final Callable<Void> jdkConnector;
    private final AtomicBoolean connectionClosed = new AtomicBoolean(false);
    private volatile boolean proxy;
    private volatile Connection wsConnection;
    private volatile boolean connectedToProxy = false;
    private volatile CompletionHandler<Void> connectCompletionHandler;

    ClientFilter(Filter downstreamFilter, ClientEngine clientEngine, Map<String, Object> properties, Callable<Void> jdkConnector, UpgradeRequest upgradeRequest) throws DeploymentException {
        super(downstreamFilter);
        this.clientEngine = clientEngine;
        this.proxyHeaders = ClientFilter.getProxyHeaders(properties);
        this.jdkConnector = jdkConnector;
        this.upgradeRequest = upgradeRequest;
    }

    void connect(SocketAddress address, boolean proxy, CompletionHandler<Void> connectCompletionHandler) {
        this.connectCompletionHandler = connectCompletionHandler;
        this.proxy = proxy;
        this.downstreamFilter.connect(address, this);
    }

    @Override
    public void processConnect() {
        JdkUpgradeRequest handshakeUpgradeRequest = this.proxy ? this.createProxyUpgradeRequest(this.upgradeRequest.getRequestURI()) : this.getJdkUpgradeRequest(this.upgradeRequest, this.downstreamFilter);
        this.sendRequest(this.downstreamFilter, handshakeUpgradeRequest);
    }

    private void sendRequest(Filter downstreamFilter, JdkUpgradeRequest handshakeUpgradeRequest) {
        downstreamFilter.write(HttpRequestBuilder.build(handshakeUpgradeRequest), new CompletionHandler<ByteBuffer>(){

            public void failed(Throwable throwable) {
                ClientFilter.this.onError(throwable);
            }
        });
    }

    private JdkUpgradeRequest getJdkUpgradeRequest(UpgradeRequest upgradeRequest, Filter downstreamFilter) {
        downstreamFilter.startSsl();
        return this.createHandshakeUpgradeRequest(upgradeRequest);
    }

    @Override
    public boolean processRead(ByteBuffer data) {
        if (this.wsConnection == null) {
            TyrusUpgradeResponse tyrusUpgradeResponse;
            try {
                this.responseParser.appendData(data);
                if (!this.responseParser.isComplete()) {
                    return false;
                }
                try {
                    tyrusUpgradeResponse = this.responseParser.parseUpgradeResponse();
                }
                finally {
                    this.responseParser.clear();
                }
            }
            catch (ParseException e) {
                this.clientEngine.processError((Throwable)e);
                this.closeConnection();
                return false;
            }
            if (this.proxy && !this.connectedToProxy) {
                if (tyrusUpgradeResponse.getStatus() != 200) {
                    this.processError(new IOException("Could not connect to a proxy. The proxy returned the following status code: " + tyrusUpgradeResponse.getStatus()));
                    return false;
                }
                this.connectedToProxy = true;
                this.downstreamFilter.startSsl();
                this.sendRequest(this.downstreamFilter, this.createHandshakeUpgradeRequest(this.upgradeRequest));
                return false;
            }
            JdkWriter writer = new JdkWriter(this.downstreamFilter, this.connectionClosed);
            ClientEngine.ClientUpgradeInfo clientUpgradeInfo = this.clientEngine.processResponse((UpgradeResponse)tyrusUpgradeResponse, (Writer)writer, new Connection.CloseListener(){

                public void close(CloseReason reason) {
                    ClientFilter.this.closeConnection();
                }
            });
            switch (clientUpgradeInfo.getUpgradeStatus()) {
                case ANOTHER_UPGRADE_REQUEST_REQUIRED: {
                    this.closeConnection();
                    try {
                        this.jdkConnector.call();
                    }
                    catch (Exception e) {
                        this.closeConnection();
                        this.clientEngine.processError((Throwable)e);
                    }
                    break;
                }
                case SUCCESS: {
                    this.wsConnection = clientUpgradeInfo.createConnection();
                    if (!data.hasRemaining()) break;
                    this.wsConnection.getReadHandler().handle(data);
                    break;
                }
                case UPGRADE_REQUEST_FAILED: {
                    this.closeConnection();
                    break;
                }
            }
        } else {
            this.wsConnection.getReadHandler().handle(data);
        }
        return false;
    }

    @Override
    public void processConnectionClosed() {
        LOGGER.log(Level.FINE, "Connection has been closed by the server");
        if (this.connectCompletionHandler != null) {
            this.connectCompletionHandler.failed((Throwable)new IOException("Connection closed by server"));
        }
        if (this.wsConnection == null) {
            return;
        }
        this.wsConnection.close(CloseReasons.CLOSED_ABNORMALLY.getCloseReason());
    }

    @Override
    void processError(Throwable t) {
        if (this.connectCompletionHandler != null) {
            this.closeConnection();
            this.connectCompletionHandler.failed(t);
            return;
        }
        LOGGER.log(Level.SEVERE, "Connection error has occurred", t);
        if (this.wsConnection != null) {
            this.wsConnection.close(CloseReasons.CLOSED_ABNORMALLY.getCloseReason());
        }
        this.closeConnection();
    }

    @Override
    void processSslHandshakeCompleted() {
        this.connectCompletionHandler.completed(null);
        this.connectCompletionHandler = null;
    }

    @Override
    void close() {
        this.closeConnection();
    }

    private void closeConnection() {
        if (this.connectionClosed.compareAndSet(false, true)) {
            this.downstreamFilter.close();
        }
    }

    private JdkUpgradeRequest createHandshakeUpgradeRequest(final UpgradeRequest upgradeRequest) {
        return new JdkUpgradeRequest(upgradeRequest){

            @Override
            public String getHttpMethod() {
                return "GET";
            }

            public String getRequestUri() {
                StringBuilder sb = new StringBuilder();
                URI uri = URI.create(upgradeRequest.getRequestUri());
                sb.append(uri.getPath());
                String query = uri.getQuery();
                if (query != null) {
                    sb.append('?').append(query);
                }
                if (sb.length() == 0) {
                    sb.append('/');
                }
                return sb.toString();
            }
        };
    }

    private JdkUpgradeRequest createProxyUpgradeRequest(final URI uri) {
        return new JdkUpgradeRequest(null){

            @Override
            public String getHttpMethod() {
                return "CONNECT";
            }

            public String getRequestUri() {
                int requestPort = Utils.getWsPort((URI)uri);
                return String.format("%s:%d", uri.getHost(), requestPort);
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                if (ClientFilter.this.proxyHeaders != null) {
                    for (Map.Entry entry : ClientFilter.this.proxyHeaders.entrySet()) {
                        headers.put((String)entry.getKey(), Collections.singletonList(entry.getValue()));
                    }
                }
                headers.put("Host", Collections.singletonList(uri.getHost()));
                headers.put("ProxyConnection", Collections.singletonList("keep-alive"));
                headers.put("Connection", Collections.singletonList("keep-alive"));
                return headers;
            }
        };
    }

    private static Map<String, String> getProxyHeaders(Map<String, Object> properties) throws DeploymentException {
        HashMap<String, String> proxyHeaders = (HashMap<String, String>)Utils.getProperty(properties, (String)"org.glassfish.tyrus.client.proxy.headers", Map.class);
        String wlsProxyUsername = null;
        String wlsProxyPassword = null;
        Object value = properties.get("weblogic.websocket.client.PROXY_USERNAME");
        if (value != null) {
            if (value instanceof String) {
                wlsProxyUsername = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_USERNAME only accept String values.");
            }
        }
        if ((value = properties.get("weblogic.websocket.client.PROXY_PASSWORD")) != null) {
            if (value instanceof String) {
                wlsProxyPassword = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_PASSWORD only accept String values.");
            }
        }
        if (proxyHeaders == null) {
            if (wlsProxyUsername != null && wlsProxyPassword != null) {
                proxyHeaders = new HashMap<String, String>();
                proxyHeaders.put("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((wlsProxyUsername + ":" + wlsProxyPassword).getBytes(Charset.forName("UTF-8"))));
            }
        } else {
            boolean proxyAuthPresent = false;
            for (Map.Entry entry : proxyHeaders.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Proxy-Authorization")) continue;
                proxyAuthPresent = true;
            }
            if (!proxyAuthPresent && wlsProxyUsername != null && wlsProxyPassword != null) {
                proxyHeaders.put("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((wlsProxyUsername + ":" + wlsProxyPassword).getBytes(Charset.forName("UTF-8"))));
            }
        }
        return proxyHeaders;
    }

    private static class JdkWriter
    extends Writer {
        private final Filter downstreamFilter;
        private final AtomicBoolean connectionClosed;

        JdkWriter(Filter downstreamFilter, AtomicBoolean connectionClosed) {
            this.downstreamFilter = downstreamFilter;
            this.connectionClosed = connectionClosed;
        }

        public void close() throws IOException {
            if (this.connectionClosed.compareAndSet(false, true)) {
                this.downstreamFilter.close();
            }
        }

        public void write(ByteBuffer buffer, CompletionHandler<ByteBuffer> completionHandler) {
            this.downstreamFilter.write(buffer, completionHandler);
        }
    }
}

