/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import org.glassfish.tyrus.container.jdk.client.Filter;
import org.glassfish.tyrus.container.jdk.client.HttpRequestBuilder;
import org.glassfish.tyrus.container.jdk.client.HttpResponseParser;
import org.glassfish.tyrus.container.jdk.client.JdkUpgradeRequest;
import org.glassfish.tyrus.container.jdk.client.ParseException;
import org.glassfish.tyrus.core.CloseReasons;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

class ClientFilter
extends Filter {
    private static final Logger LOGGER = Logger.getLogger(ClientFilter.class.getName());
    private final ClientEngine engine;
    private final URI uri;
    private final HttpResponseParser responseParser = new HttpResponseParser();
    private final boolean proxy;
    private volatile Connection wsConnection;
    private volatile boolean connectedToProxy = false;
    private volatile UpgradeRequest upgradeRequest;

    ClientFilter(ClientEngine engine, URI uri, boolean proxy) {
        this.engine = engine;
        this.uri = uri;
        this.proxy = proxy;
    }

    @Override
    public void onConnect(final Filter downstreamFilter) {
        JdkUpgradeRequest handshakeUpgradeRequest;
        this.upgradeRequest = this.engine.createUpgradeRequest(this.uri, new ClientEngine.TimeoutHandler(){

            public void handleTimeout() {
                downstreamFilter.close();
            }
        });
        if (!this.proxy) {
            downstreamFilter.startSsl();
            handshakeUpgradeRequest = this.createHandshakeUpgradeRequest(this.upgradeRequest);
        } else {
            handshakeUpgradeRequest = this.createProxyUpgradeRequest(this.upgradeRequest);
        }
        downstreamFilter.write(HttpRequestBuilder.build(handshakeUpgradeRequest), new CompletionHandler<ByteBuffer>(){

            public void failed(Throwable throwable) {
                ClientFilter.this.closeConnection(downstreamFilter);
            }
        });
    }

    @Override
    public void onRead(final Filter downstreamFilter, ByteBuffer data) {
        if (this.proxy && !this.connectedToProxy) {
            TyrusUpgradeResponse tyrusUpgradeResponse;
            this.responseParser.appendData(data);
            if (!this.responseParser.isComplete()) {
                return;
            }
            try {
                tyrusUpgradeResponse = this.responseParser.parseUpgradeResponse();
            }
            catch (ParseException e) {
                LOGGER.log(Level.SEVERE, "Parsing HTTP proxy response failed", e);
                this.closeConnection(downstreamFilter);
                return;
            }
            this.responseParser.clear();
            if (tyrusUpgradeResponse.getStatus() != 200) {
                LOGGER.log(Level.SEVERE, "Could not connect to proxy: " + tyrusUpgradeResponse.getStatus());
                this.closeConnection(downstreamFilter);
                return;
            }
            this.connectedToProxy = true;
            downstreamFilter.startSsl();
            downstreamFilter.write(HttpRequestBuilder.build(this.createHandshakeUpgradeRequest(this.upgradeRequest)), new CompletionHandler<ByteBuffer>(){

                public void failed(Throwable throwable) {
                    ClientFilter.this.closeConnection(downstreamFilter);
                }
            });
            return;
        }
        if (this.wsConnection == null) {
            TyrusUpgradeResponse tyrusUpgradeResponse;
            this.responseParser.appendData(data);
            if (!this.responseParser.isComplete()) {
                return;
            }
            try {
                tyrusUpgradeResponse = this.responseParser.parseUpgradeResponse();
            }
            catch (ParseException e) {
                LOGGER.log(Level.SEVERE, "Parsing HTTP handshake response failed", e);
                this.closeConnection(downstreamFilter);
                return;
            }
            this.responseParser.destroy();
            this.handleUpgradeResponse(downstreamFilter, tyrusUpgradeResponse);
            if (this.wsConnection == null) {
                this.closeConnection(downstreamFilter);
                return;
            }
        }
        this.wsConnection.getReadHandler().handle(data);
    }

    @Override
    public void onConnectionClosed() {
        if (this.wsConnection == null) {
            return;
        }
        this.wsConnection.close(CloseReasons.CLOSED_ABNORMALLY.getCloseReason());
    }

    private void closeConnection(Filter downstreamFilter) {
        downstreamFilter.close();
    }

    private void handleUpgradeResponse(final Filter downstreamFilter, TyrusUpgradeResponse tyrusUpgradeResponse) {
        JdkWriter writer = new JdkWriter(downstreamFilter);
        this.wsConnection = this.engine.processResponse((UpgradeResponse)tyrusUpgradeResponse, (Writer)writer, new Connection.CloseListener(){

            public void close(CloseReason reason) {
                ClientFilter.this.closeConnection(downstreamFilter);
            }
        });
    }

    private JdkUpgradeRequest createHandshakeUpgradeRequest(final UpgradeRequest upgradeRequest) {
        return new JdkUpgradeRequest(upgradeRequest){

            @Override
            public String getHttpMethod() {
                return "GET";
            }

            public String getRequestUri() {
                StringBuilder sb = new StringBuilder();
                URI uri = URI.create(upgradeRequest.getRequestUri());
                sb.append(uri.getPath());
                String query = uri.getQuery();
                if (query != null) {
                    sb.append('?').append(query);
                }
                if (sb.length() == 0) {
                    sb.append('/');
                }
                return sb.toString();
            }
        };
    }

    private JdkUpgradeRequest createProxyUpgradeRequest(final UpgradeRequest upgradeRequest) {
        return new JdkUpgradeRequest(upgradeRequest){

            @Override
            public String getHttpMethod() {
                return "CONNECT";
            }

            public String getRequestUri() {
                URI uri = URI.create(upgradeRequest.getRequestUri());
                int requestPort = uri.getPort() == -1 ? (uri.getScheme().equals("wss") ? 443 : 80) : uri.getPort();
                return String.format("%s:%d", uri.getHost(), requestPort);
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                URI uri = URI.create(upgradeRequest.getRequestUri());
                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                headers.put("Host", Collections.singletonList(uri.getHost()));
                headers.put("ProxyConnection", Collections.singletonList("keep-alive"));
                headers.put("Connection", Collections.singletonList("keep-alive"));
                return headers;
            }
        };
    }

    private static class JdkWriter
    extends Writer {
        private final Filter downstreamFilter;

        JdkWriter(Filter downstreamFilter) {
            this.downstreamFilter = downstreamFilter;
        }

        public void close() throws IOException {
            this.downstreamFilter.close();
        }

        public void write(ByteBuffer buffer, CompletionHandler<ByteBuffer> completionHandler) {
            this.downstreamFilter.write(buffer, completionHandler);
        }
    }
}

