/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import org.glassfish.tyrus.container.jdk.client.ClientFilter;
import org.glassfish.tyrus.container.jdk.client.SslContextConfigurator;
import org.glassfish.tyrus.container.jdk.client.SslEngineConfigurator;
import org.glassfish.tyrus.container.jdk.client.SslFilter;
import org.glassfish.tyrus.container.jdk.client.TaskQueueFilter;
import org.glassfish.tyrus.container.jdk.client.TransportFilter;
import org.glassfish.tyrus.spi.ClientContainer;
import org.glassfish.tyrus.spi.ClientEngine;

public class JdkClientContainer
implements ClientContainer {
    private static final int SSL_INPUT_BUFFER_SIZE = 16384;
    private static final int INPUT_BUFFER_SIZE = 2048;
    private static final Logger logger = Logger.getLogger(JdkClientContainer.class.getName());
    private final List<Proxy> proxies = new ArrayList<Proxy>();

    public void openClientSocket(String url, ClientEndpointConfig cec, Map<String, Object> properties, ClientEngine clientEngine) throws DeploymentException, IOException {
        TransportFilter transportFilter;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid URI.", (Throwable)e);
        }
        boolean proxy = false;
        String proxyUri = null;
        if (properties.get("org.glassfish.tyrus.client.proxy") != null) {
            proxy = true;
            if (!(properties.get("org.glassfish.tyrus.client.proxy") instanceof String)) {
                throw new DeploymentException("Proxy URI must be passed as String");
            }
            proxyUri = (String)properties.get("org.glassfish.tyrus.client.proxy");
        }
        ClientFilter clientFilter = new ClientFilter(clientEngine, uri, proxy);
        TaskQueueFilter writeQueue = new TaskQueueFilter(clientFilter);
        if (uri.getScheme().equalsIgnoreCase("wss")) {
            SslEngineConfigurator sslEngineConfigurator = (SslEngineConfigurator)properties.get("org.glassfish.tyrus.client.sslEngineConfigurator");
            if (sslEngineConfigurator == null) {
                SslContextConfigurator defaultConfig = new SslContextConfigurator();
                defaultConfig.retrieve(System.getProperties());
                sslEngineConfigurator = new SslEngineConfigurator(defaultConfig, true, false, false);
            }
            SslFilter sslConnection = new SslFilter(writeQueue, sslEngineConfigurator);
            transportFilter = new TransportFilter(sslConnection, 16384);
        } else {
            transportFilter = new TransportFilter(writeQueue, 2048);
        }
        if (proxy) {
            this.processProxy(proxyUri, uri);
            this.connectThroughProxy(transportFilter, uri);
            return;
        }
        transportFilter.connect(this.getServerAddress(uri), null);
    }

    private SocketAddress getServerAddress(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            String scheme = uri.getScheme();
            assert (scheme != null && (scheme.equals("ws") || scheme.equals("wss")));
            if (scheme.equals("ws")) {
                port = 80;
            } else if (scheme.equals("wss")) {
                port = 443;
            }
        }
        return new InetSocketAddress(uri.getHost(), port);
    }

    private void connectThroughProxy(TransportFilter transportFilter, URI uri) throws DeploymentException {
        for (Proxy proxy : this.proxies) {
            InetSocketAddress inetSocketAddress;
            if (proxy.type() == Proxy.Type.DIRECT) {
                throw new DeploymentException("No proxy found");
            }
            logger.log(Level.CONFIG, String.format("Connecting to '%s' via proxy '%s'.", uri, proxy));
            SocketAddress proxyAddress = proxy.address();
            if (proxyAddress instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)proxyAddress).isUnresolved()) {
                proxyAddress = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            }
            final AtomicBoolean success = new AtomicBoolean(false);
            final CountDownLatch connectLatch = new CountDownLatch(1);
            try {
                transportFilter.connect(proxyAddress, new CompletionHandler<Void, Void>(){

                    @Override
                    public void completed(Void result, Void attachment) {
                        success.set(true);
                        connectLatch.countDown();
                    }

                    @Override
                    public void failed(Throwable exc, Void attachment) {
                        connectLatch.countDown();
                    }
                });
                connectLatch.await();
                if (!success.get()) continue;
                return;
            }
            catch (IOException | InterruptedException e) {
                logger.log(Level.FINE, "Connecting to " + proxyAddress + " failed", e);
            }
        }
        throw new DeploymentException("Failed to connect to all proxies.");
    }

    private void processProxy(String proxyString, URI uri) {
        try {
            if (proxyString != null) {
                URI proxyUri = new URI(proxyString);
                if (proxyUri.getHost() == null) {
                    logger.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString));
                } else {
                    int proxyPort = proxyUri.getPort() == -1 ? 80 : proxyUri.getPort();
                    this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyPort)));
                }
            }
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString), e);
        }
        ProxySelector proxySelector = ProxySelector.getDefault();
        this.addProxies(proxySelector, uri, "socket", this.proxies);
        this.addProxies(proxySelector, uri, "https", this.proxies);
        this.addProxies(proxySelector, uri, "http", this.proxies);
    }

    private void addProxies(ProxySelector proxySelector, URI uri, String scheme, List<Proxy> proxies) {
        for (Proxy p : proxySelector.select(this.getProxyUri(uri, scheme))) {
            switch (p.type()) {
                case HTTP: {
                    logger.log(Level.FINE, String.format("Found proxy: '%s'", p));
                    proxies.add(p);
                    break;
                }
                case SOCKS: {
                    logger.log(Level.INFO, String.format("Socks proxy is not supported, please file new issue at https://java.net/jira/browse/TYRUS. Proxy '%s' will be ignored.", p));
                    break;
                }
            }
        }
    }

    private URI getProxyUri(URI wsUri, String scheme) {
        try {
            return new URI(scheme, wsUri.getUserInfo(), wsUri.getHost(), wsUri.getPort(), wsUri.getPath(), wsUri.getQuery(), wsUri.getFragment());
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, String.format("Exception during generating proxy URI '%s'", wsUri), e);
            return wsUri;
        }
    }
}

