/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.glassfish.tyrus.container.jdk.client.Filter;
import org.glassfish.tyrus.container.jdk.client.SslEngineConfigurator;
import org.glassfish.tyrus.spi.CompletionHandler;

class SslFilter
extends Filter {
    private static final Logger LOGGER = Logger.getLogger(SslFilter.class.getName());
    private final ByteBuffer applicationInputBuffer;
    private final ByteBuffer networkOutputBuffer;
    private final Filter upstreamFilter;
    private final SSLEngine sslEngine;
    private volatile Filter downstreamFilter;
    private volatile boolean sslStarted = false;

    SslFilter(Filter upstreamFilter, SslEngineConfigurator sslEngineConfigurator) {
        this.upstreamFilter = upstreamFilter;
        this.sslEngine = sslEngineConfigurator.createSSLEngine();
        this.applicationInputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.networkOutputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
    }

    @Override
    void write(ByteBuffer applicationData, CompletionHandler<ByteBuffer> completionHandler) {
        if (!this.sslStarted) {
            this.downstreamFilter.write(applicationData, completionHandler);
            return;
        }
        try {
            this.networkOutputBuffer.clear();
            this.sslEngine.wrap(applicationData, this.networkOutputBuffer);
            this.networkOutputBuffer.flip();
            this.downstreamFilter.write(this.networkOutputBuffer, completionHandler);
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    @Override
    void close() {
        if (!this.sslStarted) {
            this.downstreamFilter.close();
            this.downstreamFilter = null;
            return;
        }
        this.sslEngine.closeOutbound();
        this.write(this.networkOutputBuffer, new CompletionHandler<ByteBuffer>(){

            public void completed(ByteBuffer result) {
                SslFilter.this.downstreamFilter.close();
                SslFilter.this.downstreamFilter = null;
            }

            public void failed(Throwable throwable) {
                SslFilter.this.downstreamFilter.close();
                SslFilter.this.downstreamFilter = null;
            }
        });
    }

    @Override
    void onConnect(Filter downstreamFilter) {
        this.downstreamFilter = downstreamFilter;
        this.upstreamFilter.onConnect(this);
    }

    @Override
    void onRead(Filter downstreamFilter, ByteBuffer networkData) {
        if (!this.sslStarted) {
            this.upstreamFilter.onRead(this, networkData);
            return;
        }
        SSLEngineResult.HandshakeStatus hs = this.sslEngine.getHandshakeStatus();
        try {
            if (hs != SSLEngineResult.HandshakeStatus.FINISHED && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                SSLEngineResult result;
                if (hs != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    return;
                }
                do {
                    if ((result = this.sslEngine.unwrap(networkData, this.applicationInputBuffer)).getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        return;
                    }
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                    this.upstreamFilter.onSslHandshakeCompleted();
                    return;
                } while (networkData.hasRemaining() && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                this.doHandshakeStep(downstreamFilter);
            } else {
                do {
                    this.applicationInputBuffer.clear();
                    SSLEngineResult result = this.sslEngine.unwrap(networkData, this.applicationInputBuffer);
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        return;
                    }
                    this.applicationInputBuffer.flip();
                    this.upstreamFilter.onRead(downstreamFilter, this.applicationInputBuffer);
                } while (networkData.hasRemaining());
            }
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    @Override
    void onConnectionClosed() {
        this.upstreamFilter.onConnectionClosed();
    }

    private void doHandshakeStep(final Filter filter) {
        SSLEngineResult.HandshakeStatus hs = this.sslEngine.getHandshakeStatus();
        try {
            switch (hs) {
                case NEED_WRAP: {
                    this.networkOutputBuffer.clear();
                    this.sslEngine.wrap(this.networkOutputBuffer, this.networkOutputBuffer);
                    this.networkOutputBuffer.flip();
                    filter.write(this.networkOutputBuffer, new CompletionHandler<ByteBuffer>(){

                        public void failed(Throwable throwable) {
                            SslFilter.this.handleSslError(throwable);
                        }

                        public void completed(ByteBuffer result) {
                            if (SslFilter.this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                                return;
                            }
                            SslFilter.this.doHandshakeStep(filter);
                        }
                    });
                    break;
                }
                case NEED_TASK: {
                    Runnable delegatedTask;
                    while ((delegatedTask = this.sslEngine.getDelegatedTask()) != null) {
                        delegatedTask.run();
                    }
                    if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        LOGGER.log(Level.SEVERE, "SSL handshake error has occurred - more data needed for validating the certificate");
                        this.upstreamFilter.onConnectionClosed();
                        return;
                    }
                    this.doHandshakeStep(filter);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleSslError(e);
        }
    }

    private void handleSslError(Throwable e) {
        LOGGER.log(Level.SEVERE, "SSL error has occurred", e);
        this.upstreamFilter.onConnectionClosed();
    }

    @Override
    void startSsl() {
        try {
            this.sslStarted = true;
            this.sslEngine.beginHandshake();
            this.doHandshakeStep(this.downstreamFilter);
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }
}

