/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.tyrus.container.jdk.client.Filter;
import org.glassfish.tyrus.spi.CompletionHandler;

class TaskQueueFilter
extends Filter {
    private final Queue<Task> taskQueue = new ConcurrentLinkedQueue<Task>();
    private final AtomicBoolean taskLock = new AtomicBoolean(false);
    private final Filter upstreamFilter;
    private volatile Filter downstreamFilter;

    TaskQueueFilter(Filter upstreamFilter) {
        this.upstreamFilter = upstreamFilter;
    }

    @Override
    void write(ByteBuffer data, CompletionHandler<ByteBuffer> completionHandler) {
        this.taskQueue.offer(new WriteTask(data, completionHandler));
        if (this.taskLock.compareAndSet(false, true)) {
            this.processTask();
        }
    }

    private void processTask() {
        Task task = this.taskQueue.poll();
        if (task == null) {
            this.taskLock.set(false);
            return;
        }
        task.execute(this);
    }

    @Override
    void close() {
        this.taskQueue.offer(new Task(){

            @Override
            public void execute(TaskQueueFilter queueFilter) {
                if (TaskQueueFilter.this.downstreamFilter == null) {
                    TaskQueueFilter.this.downstreamFilter.close();
                    TaskQueueFilter.this.downstreamFilter = null;
                }
                TaskQueueFilter.this.processTask();
            }
        });
        if (this.taskLock.compareAndSet(false, true)) {
            this.processTask();
        }
    }

    @Override
    void startSsl() {
        this.taskQueue.offer(new Task(){

            @Override
            public void execute(TaskQueueFilter queueFilter) {
                TaskQueueFilter.this.downstreamFilter.startSsl();
            }
        });
        if (this.taskLock.compareAndSet(false, true)) {
            this.processTask();
        }
    }

    @Override
    void onConnect(Filter connection) {
        this.downstreamFilter = connection;
        this.upstreamFilter.onConnect(this);
    }

    @Override
    void onRead(Filter filter, ByteBuffer buffer) {
        this.upstreamFilter.onRead(this, buffer);
    }

    @Override
    void onConnectionClosed() {
        this.upstreamFilter.onConnectionClosed();
        this.close();
    }

    @Override
    void onSslHandshakeCompleted() {
        this.processTask();
    }

    static class WriteTask
    implements Task {
        private final ByteBuffer data;
        private final CompletionHandler<ByteBuffer> completionHandler;

        WriteTask(ByteBuffer data, CompletionHandler<ByteBuffer> completionHandler) {
            this.data = data;
            this.completionHandler = completionHandler;
        }

        @Override
        public void execute(final TaskQueueFilter queueFilter) {
            if (queueFilter.downstreamFilter == null) {
                this.getCompletionHandler().failed(new Throwable("Connection has been closed"));
                return;
            }
            queueFilter.downstreamFilter.write(this.getData(), new CompletionHandler<ByteBuffer>(){

                public void failed(Throwable throwable) {
                    WriteTask.this.getCompletionHandler().failed(throwable);
                    queueFilter.processTask();
                }

                public void completed(ByteBuffer result) {
                    if (result.hasRemaining()) {
                        WriteTask.this.execute(queueFilter);
                        return;
                    }
                    WriteTask.this.getCompletionHandler().completed((Object)WriteTask.this.getData());
                    queueFilter.processTask();
                }
            });
        }

        ByteBuffer getData() {
            return this.data;
        }

        CompletionHandler<ByteBuffer> getCompletionHandler() {
            return this.completionHandler;
        }
    }

    static interface Task {
        public void execute(TaskQueueFilter var1);
    }
}

