/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.CompletionHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import org.glassfish.tyrus.client.SslContextConfigurator;
import org.glassfish.tyrus.container.jdk.client.ClientFilter;
import org.glassfish.tyrus.container.jdk.client.Filter;
import org.glassfish.tyrus.container.jdk.client.SslEngineConfigurator;
import org.glassfish.tyrus.container.jdk.client.SslFilter;
import org.glassfish.tyrus.container.jdk.client.TaskQueueFilter;
import org.glassfish.tyrus.container.jdk.client.TransportFilter;
import org.glassfish.tyrus.core.Base64Utils;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.spi.ClientContainer;
import org.glassfish.tyrus.spi.ClientEngine;

public class JdkClientContainer
implements ClientContainer {
    private static final int SSL_INPUT_BUFFER_SIZE = 16384;
    private static final int INPUT_BUFFER_SIZE = 2048;
    private static final Logger LOGGER = Logger.getLogger(JdkClientContainer.class.getName());
    private final List<Proxy> proxies = new ArrayList<Proxy>();

    public void openClientSocket(String url, ClientEndpointConfig cec, Map<String, Object> properties, ClientEngine clientEngine) throws DeploymentException, IOException {
        TransportFilter transportFilter;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid URI.", (Throwable)e);
        }
        ClientFilter clientFilter = new ClientFilter(clientEngine, uri, this.getProxyHeaders(properties));
        TaskQueueFilter writeQueue = new TaskQueueFilter(clientFilter);
        if (uri.getScheme().equalsIgnoreCase("wss")) {
            Object sslEngineConfiguratorObject = properties.get("org.glassfish.tyrus.client.sslEngineConfigurator");
            SslFilter sslFilter = null;
            if (sslEngineConfiguratorObject != null) {
                if (sslEngineConfiguratorObject instanceof org.glassfish.tyrus.client.SslEngineConfigurator) {
                    sslFilter = new SslFilter((Filter)writeQueue, (org.glassfish.tyrus.client.SslEngineConfigurator)sslEngineConfiguratorObject);
                } else if (sslEngineConfiguratorObject instanceof SslEngineConfigurator) {
                    sslFilter = new SslFilter((Filter)writeQueue, (SslEngineConfigurator)sslEngineConfiguratorObject);
                } else {
                    LOGGER.log(Level.WARNING, "Invalid 'org.glassfish.tyrus.client.sslEngineConfigurator' property value: " + sslEngineConfiguratorObject + ". Using system defaults.");
                }
            }
            if (sslFilter == null) {
                SslContextConfigurator defaultConfig = new SslContextConfigurator();
                defaultConfig.retrieve(System.getProperties());
                String wlsSslTrustStore = (String)cec.getUserProperties().get("weblogic.websocket.client.SSL_TRUSTSTORE");
                String wlsSslTrustStorePassword = (String)cec.getUserProperties().get("weblogic.websocket.client.SSL_TRUSTSTORE_PWD");
                if (wlsSslTrustStore != null) {
                    defaultConfig.setTrustStoreFile(wlsSslTrustStore);
                    if (wlsSslTrustStorePassword != null) {
                        defaultConfig.setTrustStorePassword(wlsSslTrustStorePassword);
                    }
                }
                org.glassfish.tyrus.client.SslEngineConfigurator sslEngineConfigurator = new org.glassfish.tyrus.client.SslEngineConfigurator(defaultConfig, true, false, false);
                String wlsSslProtocols = (String)cec.getUserProperties().get("weblogic.websocket.client.SSL_PROTOCOLS");
                if (wlsSslProtocols != null) {
                    sslEngineConfigurator.setEnabledProtocols(wlsSslProtocols.split(","));
                }
                sslFilter = new SslFilter((Filter)writeQueue, sslEngineConfigurator);
            }
            transportFilter = new TransportFilter(sslFilter, 16384);
        } else {
            transportFilter = new TransportFilter(writeQueue, 2048);
        }
        this.processProxy(properties, uri);
        this.connect(clientFilter, transportFilter, uri);
    }

    private SocketAddress getServerAddress(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            String scheme = uri.getScheme();
            assert (scheme != null && (scheme.equals("ws") || scheme.equals("wss")));
            if (scheme.equals("ws")) {
                port = 80;
            } else if (scheme.equals("wss")) {
                port = 443;
            }
        }
        return new InetSocketAddress(uri.getHost(), port);
    }

    private void connect(ClientFilter clientFilter, TransportFilter transportFilter, URI uri) throws DeploymentException, IOException {
        for (Proxy proxy : this.proxies) {
            InetSocketAddress inetSocketAddress;
            if (proxy.type() == Proxy.Type.DIRECT) {
                clientFilter.setProxy(false);
                transportFilter.connect(this.getServerAddress(uri), null);
                return;
            }
            clientFilter.setProxy(true);
            LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' via proxy '%s'.", uri, proxy));
            SocketAddress proxyAddress = proxy.address();
            if (proxyAddress instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)proxyAddress).isUnresolved()) {
                proxyAddress = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            }
            final AtomicBoolean success = new AtomicBoolean(false);
            final CountDownLatch connectLatch = new CountDownLatch(1);
            try {
                transportFilter.connect(proxyAddress, new CompletionHandler<Void, Void>(){

                    @Override
                    public void completed(Void result, Void attachment) {
                        success.set(true);
                        connectLatch.countDown();
                    }

                    @Override
                    public void failed(Throwable exc, Void attachment) {
                        connectLatch.countDown();
                    }
                });
                connectLatch.await();
                if (!success.get()) continue;
                return;
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.FINE, "Connecting to " + proxyAddress + " failed", e);
            }
        }
    }

    private void processProxy(Map<String, Object> properties, URI uri) throws DeploymentException {
        String wlsProxyHost = null;
        Integer wlsProxyPort = null;
        Object value = properties.get("weblogic.websocket.client.PROXY_HOST");
        if (value != null) {
            if (value instanceof String) {
                wlsProxyHost = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_HOST only accept String values.");
            }
        }
        if ((value = properties.get("weblogic.websocket.client.PROXY_PORT")) != null) {
            if (value instanceof Integer) {
                wlsProxyPort = (Integer)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_PORT only accept Integer values.");
            }
        }
        if (wlsProxyHost != null) {
            this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(wlsProxyHost, wlsProxyPort == null ? 80 : wlsProxyPort)));
        } else {
            Object proxyString = properties.get("org.glassfish.tyrus.client.proxy");
            try {
                if (proxyString != null) {
                    URI proxyUri = new URI(proxyString.toString());
                    if (proxyUri.getHost() == null) {
                        LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString));
                    } else {
                        int proxyPort = proxyUri.getPort() == -1 ? 80 : proxyUri.getPort();
                        this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyPort)));
                    }
                }
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString), e);
            }
        }
        ProxySelector proxySelector = ProxySelector.getDefault();
        this.addProxies(proxySelector, uri, "socket", this.proxies);
        this.addProxies(proxySelector, uri, "https", this.proxies);
        this.addProxies(proxySelector, uri, "http", this.proxies);
        this.proxies.add(Proxy.NO_PROXY);
    }

    private void addProxies(ProxySelector proxySelector, URI uri, String scheme, List<Proxy> proxies) {
        for (Proxy p : proxySelector.select(this.getProxyUri(uri, scheme))) {
            switch (p.type()) {
                case HTTP: {
                    LOGGER.log(Level.FINE, String.format("Found proxy: '%s'", p));
                    proxies.add(p);
                    break;
                }
                case SOCKS: {
                    LOGGER.log(Level.INFO, String.format("Socks proxy is not supported, please file new issue at https://java.net/jira/browse/TYRUS. Proxy '%s' will be ignored.", p));
                    break;
                }
            }
        }
    }

    private URI getProxyUri(URI wsUri, String scheme) {
        try {
            return new URI(scheme, wsUri.getUserInfo(), wsUri.getHost(), wsUri.getPort(), wsUri.getPath(), wsUri.getQuery(), wsUri.getFragment());
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Exception during generating proxy URI '%s'", wsUri), e);
            return wsUri;
        }
    }

    private Map<String, String> getProxyHeaders(Map<String, Object> properties) throws DeploymentException {
        HashMap<String, String> proxyHeaders = (HashMap<String, String>)Utils.getProperty(properties, (String)"org.glassfish.tyrus.client.proxy.headers", Map.class);
        String wlsProxyUsername = null;
        String wlsProxyPassword = null;
        Object value = properties.get("weblogic.websocket.client.PROXY_USERNAME");
        if (value != null) {
            if (value instanceof String) {
                wlsProxyUsername = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_USERNAME only accept String values.");
            }
        }
        if ((value = properties.get("weblogic.websocket.client.PROXY_PASSWORD")) != null) {
            if (value instanceof String) {
                wlsProxyPassword = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_PASSWORD only accept String values.");
            }
        }
        if (proxyHeaders == null) {
            if (wlsProxyUsername != null && wlsProxyPassword != null) {
                proxyHeaders = new HashMap<String, String>();
                proxyHeaders.put("Proxy-Authorization", "Basic " + Base64Utils.encodeToString((byte[])(wlsProxyUsername + ":" + wlsProxyPassword).getBytes(Charset.forName("UTF-8")), (boolean)false));
            }
        } else {
            boolean proxyAuthPresent = false;
            for (Map.Entry entry : proxyHeaders.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Proxy-Authorization")) continue;
                proxyAuthPresent = true;
            }
            if (!proxyAuthPresent && wlsProxyUsername != null && wlsProxyPassword != null) {
                proxyHeaders.put("Proxy-Authorization", "Basic " + Base64Utils.encodeToString((byte[])(wlsProxyUsername + ":" + wlsProxyPassword).getBytes(Charset.forName("UTF-8")), (boolean)false));
            }
        }
        return proxyHeaders;
    }
}

