/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.container.jdk.client.Filter;

class TransportFilter
extends Filter {
    private static final Logger LOGGER = Logger.getLogger(TransportFilter.class.getName());
    private static final int THREAD_POOL_INITIAL_SIZE = 4;
    private static final int CONNECTION_CLOSE_WAIT = 30000;
    private static final AtomicInteger openedConnections = new AtomicInteger(0);
    private static final ScheduledExecutorService connectionCloseScheduler = Executors.newSingleThreadScheduledExecutor();
    private static volatile AsynchronousChannelGroup channelGroup;
    private static volatile ScheduledFuture<?> closeWaitTask;
    private final Filter upstreamFilter;
    private final int inputBufferSize;
    private volatile AsynchronousSocketChannel socketChannel;

    TransportFilter(Filter upstreamFilter, int inputBufferSize) {
        this.upstreamFilter = upstreamFilter;
        this.inputBufferSize = inputBufferSize;
    }

    @Override
    void write(ByteBuffer data, final org.glassfish.tyrus.spi.CompletionHandler<ByteBuffer> completionHandler) {
        this.socketChannel.write(data, data, new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer buffer) {
                if (buffer.hasRemaining()) {
                    TransportFilter.this.write(buffer, (org.glassfish.tyrus.spi.CompletionHandler<ByteBuffer>)completionHandler);
                    return;
                }
                completionHandler.completed((Object)buffer);
            }

            @Override
            public void failed(Throwable exc, ByteBuffer buffer) {
                completionHandler.failed(exc);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (!this.socketChannel.isOpen()) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not close a connection", e);
        }
        Class<TransportFilter> clazz = TransportFilter.class;
        synchronized (TransportFilter.class) {
            openedConnections.decrementAndGet();
            if (openedConnections.get() == 0 && channelGroup != null) {
                this.scheduleClose();
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    void startSsl() {
        this.upstreamFilter.onSslHandshakeCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress serverAddress, final CompletionHandler<Void, Void> completionHandler) throws IOException {
        Class<TransportFilter> clazz = TransportFilter.class;
        synchronized (TransportFilter.class) {
            this.initializeChannelGroup();
            this.socketChannel = AsynchronousSocketChannel.open(channelGroup);
            openedConnections.incrementAndGet();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.socketChannel.connect(serverAddress, null, new CompletionHandler<Void, Void>(){

                @Override
                public void completed(Void result, Void result2) {
                    ByteBuffer inputBuffer = ByteBuffer.allocate(TransportFilter.this.inputBufferSize);
                    TransportFilter.this.upstreamFilter.onConnect(TransportFilter.this);
                    TransportFilter.this.read(inputBuffer);
                    if (completionHandler != null) {
                        completionHandler.completed(null, null);
                    }
                }

                @Override
                public void failed(Throwable exc, Void result) {
                    LOGGER.log(Level.INFO, "Connection failed", exc.getMessage());
                    if (completionHandler != null) {
                        completionHandler.failed(exc, null);
                    }
                    try {
                        TransportFilter.this.socketChannel.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Could not close connection", exc.getMessage());
                    }
                }
            });
            return;
        }
    }

    private void initializeChannelGroup() throws IOException {
        if (closeWaitTask != null) {
            closeWaitTask.cancel(true);
            closeWaitTask = null;
        }
        if (channelGroup != null) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        channelGroup = AsynchronousChannelGroup.withCachedThreadPool(executor, 4);
    }

    private void read(final ByteBuffer inputBuffer) {
        this.socketChannel.read(inputBuffer, null, new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer bytesRead, Void result) {
                if (bytesRead == -1) {
                    TransportFilter.this.upstreamFilter.onConnectionClosed();
                    return;
                }
                inputBuffer.flip();
                TransportFilter.this.upstreamFilter.onRead(TransportFilter.this, inputBuffer);
                inputBuffer.compact();
                TransportFilter.this.read(inputBuffer);
            }

            @Override
            public void failed(Throwable exc, Void result) {
                LOGGER.log(Level.SEVERE, "Reading from a socket has failed", exc.getMessage());
                TransportFilter.this.upstreamFilter.onConnectionClosed();
            }
        });
    }

    private void scheduleClose() {
        closeWaitTask = connectionCloseScheduler.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<TransportFilter> clazz = TransportFilter.class;
                synchronized (TransportFilter.class) {
                    if (closeWaitTask == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    channelGroup.shutdown();
                    channelGroup = null;
                    closeWaitTask = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }
}

