/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.container.jdk.client;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.glassfish.tyrus.container.jdk.client.Filter;
import org.glassfish.tyrus.container.jdk.client.SslEngineConfigurator;
import org.glassfish.tyrus.spi.CompletionHandler;

class SslFilter
extends Filter {
    private final ByteBuffer applicationInputBuffer;
    private final ByteBuffer networkOutputBuffer;
    private final SSLEngine sslEngine;
    private final HostnameVerifier customHostnameVerifier;
    private final String serverHost;
    private final Object handshakeLock = new Object();
    private volatile boolean sslStarted = false;
    private volatile boolean handshakeCompleted = false;

    SslFilter(Filter downstreamFilter, org.glassfish.tyrus.client.SslEngineConfigurator sslEngineConfigurator, String serverHost) {
        super(downstreamFilter);
        this.serverHost = serverHost;
        this.sslEngine = sslEngineConfigurator.createSSLEngine(serverHost);
        this.customHostnameVerifier = sslEngineConfigurator.getHostnameVerifier();
        if (sslEngineConfigurator.isHostVerificationEnabled() && sslEngineConfigurator.getHostnameVerifier() == null) {
            SSLParameters sslParameters = this.sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            this.sslEngine.setSSLParameters(sslParameters);
        }
        this.applicationInputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.networkOutputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
    }

    SslFilter(Filter downstreamFilter, SslEngineConfigurator sslEngineConfigurator) {
        super(downstreamFilter);
        this.sslEngine = sslEngineConfigurator.createSSLEngine();
        this.applicationInputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.networkOutputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        this.customHostnameVerifier = null;
        this.serverHost = null;
    }

    @Override
    void write(ByteBuffer applicationData, CompletionHandler<ByteBuffer> completionHandler) {
        if (!this.sslStarted) {
            this.downstreamFilter.write(applicationData, completionHandler);
            return;
        }
        this.handleWrite(this.networkOutputBuffer, applicationData, this.downstreamFilter, completionHandler);
    }

    private void handleWrite(final ByteBuffer networkOutputBuffer, final ByteBuffer applicationData, final Filter downstreamFilter, final CompletionHandler<ByteBuffer> completionHandler) {
        try {
            networkOutputBuffer.clear();
            this.sslEngine.wrap(applicationData, networkOutputBuffer);
            networkOutputBuffer.flip();
            downstreamFilter.write(networkOutputBuffer, new CompletionHandler<ByteBuffer>(){

                public void completed(ByteBuffer result) {
                    if (applicationData.hasRemaining()) {
                        SslFilter.this.handleWrite(networkOutputBuffer, applicationData, downstreamFilter, (CompletionHandler<ByteBuffer>)completionHandler);
                    } else {
                        completionHandler.completed((Object)applicationData);
                    }
                }

                public void failed(Throwable throwable) {
                    completionHandler.failed(throwable);
                }
            });
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    @Override
    void close() {
        if (!this.sslStarted) {
            this.downstreamFilter.close();
            return;
        }
        this.sslEngine.closeOutbound();
        this.write(this.networkOutputBuffer, new CompletionHandler<ByteBuffer>(){

            public void completed(ByteBuffer result) {
                SslFilter.this.downstreamFilter.close();
                SslFilter.this.upstreamFilter = null;
            }

            public void failed(Throwable throwable) {
                SslFilter.this.downstreamFilter.close();
                SslFilter.this.upstreamFilter = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean processRead(ByteBuffer networkData) {
        block13: {
            if (!this.sslStarted) {
                return true;
            }
            SSLEngineResult.HandshakeStatus hs = this.sslEngine.getHandshakeStatus();
            try {
                if (hs != SSLEngineResult.HandshakeStatus.FINISHED && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    Object object = this.handshakeLock;
                    synchronized (object) {
                        SSLEngineResult result;
                        if (hs != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            return false;
                        }
                        this.applicationInputBuffer.clear();
                        do {
                            if ((result = this.sslEngine.unwrap(networkData, this.applicationInputBuffer)).getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                                return false;
                            }
                            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                            this.handshakeCompleted = true;
                            if (this.customHostnameVerifier != null && !this.customHostnameVerifier.verify(this.serverHost, this.sslEngine.getSession())) {
                                this.handleSslError(new SSLException("Server host name verification using " + this.customHostnameVerifier.getClass() + " has failed"));
                            }
                            this.onSslHandshakeCompleted();
                            return false;
                        } while (networkData.hasRemaining() && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                    }
                    this.doHandshakeStep(this.downstreamFilter);
                    break block13;
                }
                do {
                    this.applicationInputBuffer.clear();
                    SSLEngineResult result = this.sslEngine.unwrap(networkData, this.applicationInputBuffer);
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        return false;
                    }
                    this.applicationInputBuffer.flip();
                    if (this.upstreamFilter == null) continue;
                    this.upstreamFilter.onRead(this.applicationInputBuffer);
                } while (networkData.hasRemaining());
            }
            catch (SSLException e) {
                this.handleSslError(e);
            }
        }
        return false;
    }

    private void doHandshakeStep(Filter filter) {
        try {
            Object object = this.handshakeLock;
            synchronized (object) {
                while (true) {
                    SSLEngineResult.HandshakeStatus hs = this.sslEngine.getHandshakeStatus();
                    if (this.handshakeCompleted || hs != SSLEngineResult.HandshakeStatus.NEED_WRAP && hs != SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        return;
                    }
                    switch (hs) {
                        case NEED_WRAP: {
                            this.networkOutputBuffer.clear();
                            this.sslEngine.wrap(this.networkOutputBuffer, this.networkOutputBuffer);
                            this.networkOutputBuffer.flip();
                            final CountDownLatch writeLatch = new CountDownLatch(1);
                            filter.write(this.networkOutputBuffer, new CompletionHandler<ByteBuffer>(){

                                public void failed(Throwable throwable) {
                                    writeLatch.countDown();
                                    SslFilter.this.handleSslError(throwable);
                                }

                                public void completed(ByteBuffer result) {
                                    writeLatch.countDown();
                                }
                            });
                            writeLatch.await();
                            break;
                        }
                        case NEED_TASK: {
                            Runnable delegatedTask;
                            while ((delegatedTask = this.sslEngine.getDelegatedTask()) != null) {
                                delegatedTask.run();
                            }
                            if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                            this.handleSslError(new SSLException("SSL handshake error has occurred - more data needed for validating the certificate"));
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleSslError(e);
            return;
        }
    }

    private void handleSslError(Throwable t) {
        this.onError(t);
    }

    @Override
    void startSsl() {
        try {
            this.sslStarted = true;
            this.sslEngine.beginHandshake();
            this.doHandshakeStep(this.downstreamFilter);
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }
}

