/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import javax.websocket.CloseReason;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

public class TyrusHttpUpgradeHandler
implements HttpUpgradeHandler,
ReadListener {
    public static final String FRAME_BUFFER_SIZE = "org.glassfish.tyrus.servlet.incoming-buffer-size";
    private final CountDownLatch connectionLatch = new CountDownLatch(1);
    private ServletInputStream is;
    private ServletOutputStream os;
    private WebConnection wc;
    private ByteBuffer buf;
    private volatile boolean closed = false;
    private int incomingBufferSize = 0x40000B;
    private static final Logger LOGGER = Logger.getLogger(TyrusHttpUpgradeHandler.class.getName());
    private Connection connection;
    private WebSocketEngine.UpgradeInfo upgradeInfo;
    private Writer writer;
    private boolean authenticated = false;

    public void init(WebConnection wc) {
        LOGGER.config("Servlet 3.1 Upgrade");
        try {
            this.is = wc.getInputStream();
            this.os = wc.getOutputStream();
            this.wc = wc;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        try {
            this.is.setReadListener((ReadListener)this);
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        this.connection = this.upgradeInfo.createConnection(this.writer, new Connection.CloseListener(){

            public void close(CloseReason reason) {
                try {
                    TyrusHttpUpgradeHandler.this.getWebConnection().close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                }
            }
        });
        this.connectionLatch.countDown();
    }

    public void preInit(WebSocketEngine.UpgradeInfo upgradeInfo, Writer writer, boolean authenticated) {
        this.upgradeInfo = upgradeInfo;
        this.writer = writer;
        this.authenticated = authenticated;
    }

    public void onDataAvailable() {
        try {
            this.connectionLatch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        do {
            try {
                int toRead;
                for (int available = this.is.available(); available > 0; available -= this.fillBuf(toRead)) {
                    int n = this.buf == null ? (available > this.incomingBufferSize ? this.incomingBufferSize : available) : (toRead = this.buf.remaining() + available > this.incomingBufferSize ? this.incomingBufferSize - this.buf.remaining() : this.buf.remaining() + available);
                    if (toRead == 0) {
                        throw new IOException(String.format("Tyrus input buffer exceeded. Current buffer size is %s bytes.", this.incomingBufferSize));
                    }
                    LOGGER.finest(String.format("Remaining Data = %d", this.buf.remaining()));
                    if (!this.buf.hasRemaining()) continue;
                    this.connection.getReadHandler().handle(this.buf);
                }
            }
            catch (IOException e) {
                this.connection.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, null));
            }
        } while (!this.closed && this.is.isReady());
    }

    private int fillBuf(int length) throws IOException {
        byte[] data = new byte[length];
        int len = this.is.read(data);
        if (len == 0) {
            throw new RuntimeException("No data available.");
        }
        if (this.buf == null) {
            LOGGER.finest("No Buffer. Allocating new one");
            this.buf = ByteBuffer.wrap(data);
            this.buf.limit(len);
        } else {
            int limit = this.buf.limit();
            int capacity = this.buf.capacity();
            int remaining = this.buf.remaining();
            if (capacity - limit >= len) {
                LOGGER.finest("Remaining data need not be moved. New data is just appended");
                this.buf.mark();
                this.buf.position(limit);
                this.buf.limit(capacity);
                this.buf.put(data, 0, len);
                this.buf.limit(limit + len);
                this.buf.reset();
            } else if (remaining + len < capacity) {
                LOGGER.finest("Remaining data is moved to left. Then new data is appended");
                this.buf.compact();
                this.buf.put(data, 0, len);
                this.buf.flip();
            } else {
                LOGGER.finest("Remaining data + new > capacity. So allocate new one");
                byte[] array = new byte[remaining + len];
                this.buf.get(array, 0, remaining);
                System.arraycopy(data, 0, array, remaining, len);
                this.buf = ByteBuffer.wrap(array);
                this.buf.limit(remaining + len);
            }
        }
        return len;
    }

    public void onAllDataRead() {
        this.close(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), null);
    }

    public void onError(Throwable t) {
        this.close(CloseReason.CloseCodes.CLOSED_ABNORMALLY.getCode(), t.getMessage() == null ? "No reason given." : t.getMessage());
    }

    public void destroy() {
        this.close(CloseReason.CloseCodes.CLOSED_ABNORMALLY.getCode(), "No reason given.");
    }

    public void sessionDestroyed() {
        if (this.authenticated) {
            this.httpSessionForcedClose(CloseReason.CloseCodes.VIOLATED_POLICY.getCode(), "No reason given.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TyrusHttpUpgradeHandler{");
        sb.append("is=").append(this.is);
        sb.append(", os=").append(this.os);
        sb.append(", wc=").append(this.wc);
        sb.append(", closed=").append(this.closed);
        sb.append('}');
        return sb.toString();
    }

    public void setIncomingBufferSize(int incomingBufferSize) {
        this.incomingBufferSize = incomingBufferSize;
    }

    private void httpSessionForcedClose(int closeCode, String closeReason) {
        if (!this.closed) {
            try {
                this.connection.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)closeCode), closeReason));
                this.closed = true;
                this.wc.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
            }
        }
    }

    private void close(int closeCode, String closeReason) {
        if (!this.closed) {
            try {
                this.connection.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)closeCode), closeReason));
                this.closed = true;
                this.wc.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
            }
        }
    }

    WebConnection getWebConnection() {
        if (this.wc == null) {
            throw new IllegalStateException();
        }
        return this.wc;
    }
}

