/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.websocket.Endpoint;
import javax.net.websocket.ServerEndpointConfiguration;
import org.glassfish.tyrus.server.ServerConfiguration;

public class DefaultServerConfiguration
implements ServerConfiguration {
    private long maxSessionIdleTimeout;
    private long maxBinaryMessageBufferSize;
    private long maxTextMessageBufferSize;
    private final Set<Class<?>> endpointClasses = new HashSet();
    private final Set<Class<?>> endpointClassesView = Collections.unmodifiableSet(this.endpointClasses);
    private final Set<ServerConfiguration.EndpointWithConfiguration> endpointInstances = new HashSet<ServerConfiguration.EndpointWithConfiguration>();
    private final Set<ServerConfiguration.EndpointWithConfiguration> endpointInstancesView = Collections.unmodifiableSet(this.endpointInstances);

    @Override
    public Set<Class<?>> getEndpointClasses() {
        return this.endpointClassesView;
    }

    @Override
    public Set<ServerConfiguration.EndpointWithConfiguration> getEndpointInstances() {
        return this.endpointInstancesView;
    }

    @Override
    public long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    @Override
    public long getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public long getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public List<String> getExtensions() {
        return Collections.emptyList();
    }

    public DefaultServerConfiguration maxSessionIdleTimeout(long max) {
        this.maxSessionIdleTimeout = max;
        return this;
    }

    public DefaultServerConfiguration maxBinaryMessageBufferSize(long max) {
        this.maxBinaryMessageBufferSize = max;
        return this;
    }

    public DefaultServerConfiguration maxTextMessageBufferSize(long max) {
        this.maxTextMessageBufferSize = max;
        return this;
    }

    public DefaultServerConfiguration endpoint(Class<?> endpointClass) {
        this.endpointClasses.add(endpointClass);
        return this;
    }

    public DefaultServerConfiguration endpoint(Endpoint endpoint, ServerEndpointConfiguration configuration) {
        this.endpointInstances.add(new ServerConfiguration.EndpointWithConfiguration(endpoint, configuration));
        return this;
    }

    public DefaultServerConfiguration endpoints(Class<?> ... endpointClasses) {
        Collections.addAll(this.endpointClasses, endpointClasses);
        return this;
    }

    public DefaultServerConfiguration endpoints(Set<Class<?>> endpointClasses) {
        this.endpointClasses.addAll(endpointClasses);
        return this;
    }
}

