/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.websocket.Decoder;
import javax.net.websocket.Encoder;
import javax.net.websocket.HandshakeRequest;
import javax.net.websocket.HandshakeResponse;
import javax.net.websocket.ServerEndpointConfiguration;
import org.glassfish.tyrus.DefaultEndpointConfiguration;

public class DefaultServerEndpointConfiguration
extends DefaultEndpointConfiguration
implements ServerEndpointConfiguration {
    private final List<String> origins;

    protected DefaultServerEndpointConfiguration(String uri, List<Encoder> encoders, List<Decoder> decoders, List<String> subprotocols, List<String> extensions, List<String> origins) {
        super(uri, encoders, decoders, subprotocols, extensions);
        this.origins = origins == null ? Collections.emptyList() : Collections.unmodifiableList(origins);
    }

    public String getNegotiatedSubprotocol(List<String> requestedSubprotocols) {
        for (String serverProtocol : this.subProtocols) {
            if (!requestedSubprotocols.contains(serverProtocol)) continue;
            return serverProtocol;
        }
        return null;
    }

    public List<String> getNegotiatedExtensions(List<String> requestedExtensions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String requestedExtension : requestedExtensions) {
            for (String extension : this.extensions) {
                if (!extension.equals(requestedExtension)) continue;
                result.add(requestedExtension);
            }
        }
        return result;
    }

    public boolean checkOrigin(String originHeaderValue) {
        return this.origins.isEmpty() || this.origins.contains(originHeaderValue);
    }

    public boolean matchesURI(URI uri) {
        throw new UnsupportedOperationException();
    }

    public void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
    }

    public static class Builder
    extends DefaultEndpointConfiguration.Builder<Builder> {
        private List<String> origins;

        public Builder(String uri) {
            super(uri);
        }

        public Builder origins(List<String> origins) {
            this.origins = origins;
            return this;
        }

        public DefaultServerEndpointConfiguration build() {
            return new DefaultServerEndpointConfiguration(this.uri, this.encoders, this.decoders, this.protocols, this.extensions, this.origins);
        }
    }
}

