/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.util.logging.Logger;
import org.glassfish.tyrus.server.ServerConfiguration;
import org.glassfish.tyrus.server.ServerContainer;
import org.glassfish.tyrus.server.TyrusServerContainer;
import org.glassfish.tyrus.spi.TyrusContainer;

public class ServerContainerFactory {
    public static ServerContainer create(String providerClassName, String contextPath, int port, ServerConfiguration configuration) {
        Class<TyrusContainer> providerClass;
        try {
            providerClass = Class.forName(providerClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load container provider class: " + providerClassName, e);
        }
        Logger.getLogger(ServerContainerFactory.class.getName()).info("Provider class loaded: " + providerClassName);
        return ServerContainerFactory.create(providerClass, contextPath, port, configuration);
    }

    public static ServerContainer create(Class<TyrusContainer> providerClass, String contextPath, int port, ServerConfiguration configuration) {
        TyrusContainer containerProvider;
        try {
            containerProvider = providerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate provider class: " + providerClass.getName(), e);
        }
        return new TyrusServerContainer(containerProvider.createServer(contextPath, port), contextPath, configuration);
    }
}

