/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.websocket.server.ServerApplicationConfiguration;
import javax.websocket.server.ServerEndpointConfiguration;
import javax.websocket.server.WebSocketEndpoint;

public class DefaultServerConfiguration
implements ServerApplicationConfiguration {
    private final Set<Class> annotatedClasses = new HashSet<Class>();
    private final Set<Class> annotatedClassesView = Collections.unmodifiableSet(this.annotatedClasses);
    private final Set<Class<? extends ServerEndpointConfiguration>> programmaticClasses = new HashSet<Class<? extends ServerEndpointConfiguration>>();
    private final Set<Class<? extends ServerEndpointConfiguration>> programmaticCLassesView = Collections.unmodifiableSet(this.programmaticClasses);

    public Set<Class<? extends ServerEndpointConfiguration>> getEndpointConfigurationClasses(Set<Class<? extends ServerEndpointConfiguration>> scanned) {
        return this.programmaticCLassesView;
    }

    public Set<Class> getAnnotatedEndpointClasses(Set<Class> scanned) {
        return this.annotatedClassesView;
    }

    public DefaultServerConfiguration endpoint(Class<?> endpointClass) throws IllegalArgumentException {
        if (endpointClass.isAnnotationPresent(WebSocketEndpoint.class)) {
            this.annotatedClasses.add(endpointClass);
        } else if (ServerEndpointConfiguration.class.isAssignableFrom(endpointClass)) {
            this.programmaticClasses.add(endpointClass);
        } else {
            throw new IllegalArgumentException("Class: " + endpointClass.getName() + " is not annotated with " + WebSocketEndpoint.class.getName());
        }
        return this;
    }

    public DefaultServerConfiguration endpoints(Class<?> ... endpointClasses) {
        for (Class<?> endpointClass : endpointClasses) {
            this.endpoint(endpointClass);
        }
        return this;
    }

    public DefaultServerConfiguration endpoints(Set<Class<?>> endpointClasses) {
        for (Class<?> endpointClass : endpointClasses) {
            this.endpoint(endpointClass);
        }
        return this;
    }
}

