/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfiguration;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfiguration;
import org.glassfish.tyrus.TyrusExtension;
import org.glassfish.tyrus.server.TyrusHandshakeRequest;
import org.glassfish.tyrus.server.TyrusRemoteEndpoint;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.websockets.DefaultWebSocket;
import org.glassfish.tyrus.websockets.Extension;
import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketListener;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;

public class TyrusEndpoint
extends WebSocketApplication
implements SPIRegisteredEndpoint {
    private final SPIEndpoint endpoint;
    private List<Extension> temporaryNegotiatedExtensions;
    private String temporaryNegotiatedProtocol;

    public TyrusEndpoint(SPIEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isApplicationRequest(WebSocketRequest o) {
        String protocols = (String)o.getHeaders().get("Sec-WebSocket-Protocol");
        this.temporaryNegotiatedProtocol = this.endpoint.getNegotiatedProtocol(protocols == null ? Collections.emptyList() : Arrays.asList(protocols.split(",")));
        List extensions = TyrusExtension.fromString((String)((String)o.getHeaders().get("Sec-WebSocket-Extensions")));
        this.temporaryNegotiatedExtensions = this.endpoint.getNegotiatedExtensions(extensions);
        return this.endpoint.checkHandshake((SPIHandshakeRequest)new TyrusHandshakeRequest(o));
    }

    public WebSocket createSocket(ProtocolHandler handler, WebSocketRequest requestPacket, WebSocketListener ... listeners) {
        return new DefaultWebSocket(handler, requestPacket, listeners);
    }

    public void onConnect(WebSocket socket) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onConnect((SPIRemoteEndpoint)gs, this.temporaryNegotiatedProtocol, this.temporaryNegotiatedExtensions);
    }

    public void onFragment(WebSocket socket, String fragment, boolean last) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        try {
            this.endpoint.onPartialMessage((SPIRemoteEndpoint)gs, fragment, last);
        }
        catch (Throwable t) {
            Logger.getLogger(TyrusEndpoint.class.getName()).severe("Error !!!" + t);
            t.printStackTrace();
        }
    }

    public void onFragment(WebSocket socket, byte[] fragment, boolean last) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        try {
            this.endpoint.onPartialMessage((SPIRemoteEndpoint)gs, ByteBuffer.wrap(fragment), last);
        }
        catch (Throwable t) {
            Logger.getLogger(TyrusEndpoint.class.getName()).severe("Error !!!" + t);
            t.printStackTrace();
        }
    }

    public void onMessage(WebSocket socket, String messageString) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onMessage((SPIRemoteEndpoint)gs, messageString);
    }

    public void onMessage(WebSocket socket, byte[] bytes) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onMessage((SPIRemoteEndpoint)gs, ByteBuffer.wrap(bytes));
    }

    public void onClose(WebSocket socket, ClosingFrame frame) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        CloseReason closeReason = null;
        if (frame != null) {
            closeReason = new CloseReason(TyrusEndpoint.getCloseCode(frame.getCode()), frame.getReason());
        }
        this.endpoint.onClose((SPIRemoteEndpoint)gs, closeReason);
        TyrusRemoteEndpoint.remove(socket);
    }

    public void onPong(WebSocket socket, byte[] bytes) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onPong((SPIRemoteEndpoint)gs, ByteBuffer.wrap(bytes));
    }

    public void remove() {
        this.endpoint.remove();
    }

    public Set<Session> getOpenSessions() {
        return this.endpoint.getOpenSessions();
    }

    public void onExtensionNegotiation(List<org.glassfish.tyrus.websockets.Extension> extensions) {
    }

    public List<org.glassfish.tyrus.websockets.Extension> getSupportedExtensions() {
        ArrayList<org.glassfish.tyrus.websockets.Extension> grizzlyExtensions = new ArrayList<org.glassfish.tyrus.websockets.Extension>();
        for (Extension ext : this.temporaryNegotiatedExtensions) {
            org.glassfish.tyrus.websockets.Extension extension = new org.glassfish.tyrus.websockets.Extension(ext.getName());
            for (Map.Entry entry : ext.getParameters().entrySet()) {
                extension.getParameters().add(new Extension.Parameter((String)entry.getKey(), (String)entry.getValue()));
            }
            grizzlyExtensions.add(extension);
        }
        return grizzlyExtensions;
    }

    public boolean onError(WebSocket webSocket, Throwable t) {
        Logger.getLogger(TyrusEndpoint.class.getName()).log(Level.WARNING, "onError!", t);
        return true;
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        List<String> result;
        if (this.temporaryNegotiatedProtocol == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            result.add(this.temporaryNegotiatedProtocol);
        }
        return result;
    }

    public void onPing(WebSocket socket, byte[] bytes) {
    }

    public void onHandShakeResponse(WebSocketRequest request, WebSocketResponse response) {
        EndpointConfiguration configuration = this.endpoint.getEndpointConfiguration();
        if (configuration instanceof ServerEndpointConfiguration) {
            HandshakeResponse handshakeResponse = this.createHandshakeResponse(response);
            ((ServerEndpointConfiguration)configuration).modifyHandshake(this.createHandshakeRequest(request), handshakeResponse);
            for (Map.Entry entry : handshakeResponse.getHeaders().entrySet()) {
                if (entry.getValue() == null) continue;
                response.getHeaders().put(entry.getKey(), ((List)entry.getValue()).get(0));
            }
        }
    }

    private HandshakeRequest createHandshakeRequest(final WebSocketRequest webSocketRequest) {
        return new HandshakeRequest(){

            public Map<String, List<String>> getHeaders() {
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.toLowerCase().compareTo(o2.toLowerCase());
                    }
                });
                for (Map.Entry entry : webSocketRequest.getHeaders().entrySet()) {
                    headers.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
                }
                return headers;
            }

            public Principal getUserPrincipal() {
                return null;
            }

            public URI getRequestURI() {
                try {
                    return new URI(webSocketRequest.getRequestURI());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public boolean isUserInRole(String role) {
                return false;
            }

            public Object getSession() {
                return null;
            }

            public Map<String, List<String>> getParameterMap() {
                return null;
            }

            public String getQueryString() {
                return webSocketRequest.getQueryString();
            }
        };
    }

    private HandshakeResponse createHandshakeResponse(WebSocketResponse webSocketResponse) {
        final TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        for (Map.Entry entry : webSocketResponse.getHeaders().entrySet()) {
            headers.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
        }
        return new HandshakeResponse(){

            public Map<String, List<String>> getHeaders() {
                return headers;
            }
        };
    }

    public static CloseReason.CloseCode getCloseCode(final int code) {
        if (code < 1000 || code > 4999) {
            throw new IllegalArgumentException();
        }
        switch (code) {
            case 1000: {
                return CloseReason.CloseCodes.NORMAL_CLOSURE;
            }
            case 1001: {
                return CloseReason.CloseCodes.GOING_AWAY;
            }
            case 1002: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1003: {
                return CloseReason.CloseCodes.CANNOT_ACCEPT;
            }
            case 1004: {
                return CloseReason.CloseCodes.RESERVED;
            }
            case 1005: {
                return CloseReason.CloseCodes.NO_STATUS_CODE;
            }
            case 1006: {
                return CloseReason.CloseCodes.CLOSED_ABNORMALLY;
            }
            case 1007: {
                return CloseReason.CloseCodes.NOT_CONSISTENT;
            }
            case 1008: {
                return CloseReason.CloseCodes.VIOLATED_POLICY;
            }
            case 1009: {
                return CloseReason.CloseCodes.TOO_BIG;
            }
            case 1010: {
                return CloseReason.CloseCodes.NO_EXTENSION;
            }
            case 1011: {
                return CloseReason.CloseCodes.UNEXPECTED_CONDITION;
            }
            case 1012: {
                return CloseReason.CloseCodes.SERVICE_RESTART;
            }
            case 1013: {
                return CloseReason.CloseCodes.TRY_AGAIN_LATER;
            }
            case 1015: {
                return CloseReason.CloseCodes.TLS_HANDSHAKE_FAILURE;
            }
        }
        return new CloseReason.CloseCode(){

            public int getCode() {
                return code;
            }
        };
    }
}

