/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerApplicationConfiguration;
import javax.websocket.server.ServerEndpointConfiguration;
import javax.websocket.server.WebSocketEndpoint;
import org.glassfish.tyrus.AnnotatedEndpoint;
import org.glassfish.tyrus.ErrorCollector;

public class TyrusServerConfiguration
implements ServerApplicationConfiguration {
    private final Set<Class<? extends ServerEndpointConfiguration>> programmaticClasses = new HashSet<Class<? extends ServerEndpointConfiguration>>();
    private final Set<Class> annotatedClasses = new HashSet<Class>();

    public TyrusServerConfiguration(Set<Class<?>> classes) {
        ErrorCollector errorCollector = new ErrorCollector();
        HashSet<ServerApplicationConfiguration> configurations = new HashSet<ServerApplicationConfiguration>();
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> cls = it.next();
            if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers()) || AnnotatedEndpoint.class.isAssignableFrom(cls)) {
                errorCollector.addException((Exception)((Object)new DeploymentException(cls.getName() + ": Deployed Classes can't be abstract nor interface. The class will not be deployed.")));
                it.remove();
            }
            if (!ServerApplicationConfiguration.class.isAssignableFrom(cls)) continue;
            try {
                ServerApplicationConfiguration config = (ServerApplicationConfiguration)cls.newInstance();
                configurations.add(config);
            }
            catch (InstantiationException e) {
                errorCollector.addException((Exception)((Object)new DeploymentException(cls.getName() + ": can't be instantiated")));
            }
            catch (IllegalAccessException e) {
                errorCollector.addException((Exception)((Object)new DeploymentException(cls.getName() + ": can't be instantiated")));
            }
        }
        HashSet scannedProgramatics = new HashSet();
        HashSet scannedAnnotateds = new HashSet();
        for (Class<?> cls : classes) {
            if (ServerEndpointConfiguration.class.isAssignableFrom(cls)) {
                scannedProgramatics.add(cls);
                continue;
            }
            if (!cls.isAnnotationPresent(WebSocketEndpoint.class)) continue;
            scannedAnnotateds.add(cls);
        }
        if (!configurations.isEmpty()) {
            for (ServerApplicationConfiguration configuration : configurations) {
                Set programmatic = configuration.getEndpointConfigurationClasses(scannedProgramatics);
                programmatic = programmatic == null ? new HashSet() : programmatic;
                this.programmaticClasses.addAll(programmatic);
                Set annotated = configuration.getAnnotatedEndpointClasses(scannedAnnotateds);
                annotated = annotated == null ? new HashSet() : annotated;
                this.annotatedClasses.addAll(annotated);
            }
        } else {
            this.programmaticClasses.addAll(scannedProgramatics);
            this.annotatedClasses.addAll(scannedAnnotateds);
        }
    }

    public Set<Class<? extends ServerEndpointConfiguration>> getEndpointConfigurationClasses(Set<Class<? extends ServerEndpointConfiguration>> scanned) {
        return Collections.unmodifiableSet(this.programmaticClasses);
    }

    public Set<Class> getAnnotatedEndpointClasses(Set<Class> scanned) {
        return Collections.unmodifiableSet(this.annotatedClasses);
    }
}

