/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfiguration;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerApplicationConfiguration;
import javax.websocket.server.ServerEndpointConfiguration;
import org.glassfish.tyrus.AnnotatedEndpoint;
import org.glassfish.tyrus.ComponentProviderService;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.ErrorCollector;
import org.glassfish.tyrus.WithProperties;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusServer;

public class TyrusServerContainer
extends WithProperties
implements WebSocketContainer {
    private final TyrusServer server;
    private final String contextPath;
    private final ServerApplicationConfiguration configuration;
    private final Set<SPIRegisteredEndpoint> endpoints = new HashSet<SPIRegisteredEndpoint>();
    private final ErrorCollector collector = new ErrorCollector();
    private long maxSessionIdleTimeout = 0L;
    private long maxTextMessageBufferSize = 0L;
    private long maxBinaryMessageBufferSize = 0L;
    private long defaultAsyncSendTimeout = 0L;

    public TyrusServerContainer(TyrusServer server, String contextPath, Set<Class<?>> classes) {
        this.server = server;
        this.contextPath = contextPath;
        this.configuration = new TyrusServerConfiguration(classes);
    }

    public void start() throws IOException, DeploymentException {
        this.server.start();
        try {
            AnnotatedEndpoint endpoint;
            for (Class endpointClass : this.configuration.getAnnotatedEndpointClasses(null)) {
                endpoint = AnnotatedEndpoint.fromClass((Class)endpointClass, (boolean)true, (ErrorCollector)this.collector);
                EndpointConfiguration config = endpoint.getEndpointConfiguration();
                this.deploy((Endpoint)endpoint, config);
            }
            for (Class endpointClass : this.configuration.getEndpointConfigurationClasses(null)) {
                ServerEndpointConfiguration seConfig = (ServerEndpointConfiguration)ComponentProviderService.getInstance((Class)endpointClass);
                endpoint = (Endpoint)ComponentProviderService.getInstance((Class)seConfig.getEndpointClass());
                this.deploy((Endpoint)endpoint, (EndpointConfiguration)seConfig);
            }
        }
        catch (DeploymentException de) {
            this.collector.addException((Exception)((Object)de));
        }
        if (!this.collector.isEmpty()) {
            this.stop();
            throw this.collector.composeComprehensiveException();
        }
    }

    private void deploy(Endpoint endpoint, EndpointConfiguration endpointConfiguration) {
        EndpointWrapper ew = new EndpointWrapper(endpoint, endpointConfiguration, (WebSocketContainer)this, this.contextPath);
        SPIRegisteredEndpoint ge = this.server.register((SPIEndpoint)ew);
        this.endpoints.add(ge);
    }

    public void stop() {
        for (SPIRegisteredEndpoint wsa : this.endpoints) {
            wsa.remove();
            this.server.unregister(wsa);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Closing down : " + wsa);
        }
        this.server.stop();
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfiguration cec, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public Set<Session> getOpenSessions() {
        HashSet result = new HashSet();
        for (SPIRegisteredEndpoint endpoint : this.endpoints) {
            result.addAll(endpoint.getOpenSessions());
        }
        return Collections.unmodifiableSet(result);
    }

    public long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setMaxSessionIdleTimeout(long timeout) {
        this.maxSessionIdleTimeout = timeout;
    }

    public long getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(long max) {
        this.maxBinaryMessageBufferSize = max;
    }

    public long getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setMaxTextMessageBufferSize(long max) {
        this.maxTextMessageBufferSize = max;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }
}

