/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfiguration;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfiguration;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ReflectionHelper;

public class TyrusServerConfiguration
implements ServerApplicationConfiguration {
    private final Set<ServerEndpointConfiguration> serverEndpointConfigurations = new HashSet<ServerEndpointConfiguration>();
    private final Set<Class<?>> annotatedClasses = new HashSet();

    public TyrusServerConfiguration(Set<Class<?>> classes, Set<ServerEndpointConfiguration> serverEndpointConfigurations) {
        this(classes, serverEndpointConfigurations, new ErrorCollector());
    }

    public TyrusServerConfiguration(Set<Class<?>> classes, Set<ServerEndpointConfiguration> serverEndpointConfigurations, ErrorCollector errorCollector) {
        if (classes == null || serverEndpointConfigurations == null || errorCollector == null) {
            throw new IllegalArgumentException();
        }
        this.serverEndpointConfigurations.addAll(serverEndpointConfigurations);
        HashSet<ServerApplicationConfiguration> configurations = new HashSet<ServerApplicationConfiguration>();
        HashSet scannedProgramatics = new HashSet();
        HashSet scannedAnnotateds = new HashSet();
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> cls = it.next();
            if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) {
                errorCollector.addException((Exception)((Object)new DeploymentException(cls.getName() + ": Deployed Classes can't be abstract nor interface. The class will not be deployed.")));
                it.remove();
            }
            if (ServerApplicationConfiguration.class.isAssignableFrom(cls)) {
                ServerApplicationConfiguration config = (ServerApplicationConfiguration)ReflectionHelper.getInstance(cls, (ErrorCollector)errorCollector);
                configurations.add(config);
            }
            if (Endpoint.class.isAssignableFrom(cls)) {
                scannedProgramatics.add(cls);
            }
            if (!cls.isAnnotationPresent(ServerEndpoint.class)) continue;
            scannedAnnotateds.add(cls);
        }
        if (!configurations.isEmpty()) {
            for (ServerApplicationConfiguration configuration : configurations) {
                Set programmatic = configuration.getEndpointConfigurations(scannedProgramatics);
                programmatic = programmatic == null ? new HashSet() : programmatic;
                this.serverEndpointConfigurations.addAll(programmatic);
                Set annotated = configuration.getAnnotatedEndpointClasses(scannedAnnotateds);
                annotated = annotated == null ? new HashSet() : annotated;
                this.annotatedClasses.addAll(annotated);
            }
        } else {
            this.annotatedClasses.addAll(scannedAnnotateds);
        }
    }

    public Set<ServerEndpointConfiguration> getEndpointConfigurations(Set<Class<? extends Endpoint>> scanned) {
        return Collections.unmodifiableSet(this.serverEndpointConfigurations);
    }

    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return Collections.unmodifiableSet(this.annotatedClasses);
    }
}

