/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfiguration;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerApplicationConfiguration;
import javax.websocket.server.ServerEndpointConfiguration;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.WithProperties;
import org.glassfish.tyrus.server.TyrusServerConfiguration;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusServer;

public class TyrusServerContainer
extends WithProperties
implements WebSocketContainer {
    private final TyrusServer server;
    private final String contextPath;
    private final ServerApplicationConfiguration configuration;
    private final Set<SPIRegisteredEndpoint> endpoints = new HashSet<SPIRegisteredEndpoint>();
    private final ErrorCollector collector = new ErrorCollector();
    private final ComponentProviderService componentProvider;
    private long defaultMaxSessionIdleTimeout = 0L;
    private long defaultAsyncSendTimeout = 0L;
    private int maxTextMessageBufferSize = 0;
    private int maxBinaryMessageBufferSize = 0;

    public TyrusServerContainer(TyrusServer server, String contextPath, Set<Class<?>> classes) {
        this.server = server;
        this.contextPath = contextPath;
        this.configuration = new TyrusServerConfiguration(classes, Collections.emptySet(), this.collector);
        this.componentProvider = ComponentProviderService.create((ErrorCollector)this.collector);
    }

    public void start() throws IOException, DeploymentException {
        this.server.start();
        try {
            for (Class endpointClass : this.configuration.getAnnotatedEndpointClasses(null)) {
                EndpointConfiguration config;
                AnnotatedEndpoint endpoint;
                EndpointWrapper ew = new EndpointWrapper((Endpoint)endpoint, config, this.componentProvider, (WebSocketContainer)this, this.contextPath, this.collector, (config = (endpoint = AnnotatedEndpoint.fromClass((Class)endpointClass, (ComponentProviderService)this.componentProvider, (boolean)true, (ErrorCollector)this.collector)).getEndpointConfiguration()) instanceof ServerEndpointConfiguration ? ((ServerEndpointConfiguration)config).getServerEndpointConfigurator() : null);
                this.deploy(ew);
            }
            for (ServerEndpointConfiguration serverEndpointConfiguration : this.configuration.getEndpointConfigurations(null)) {
                if (serverEndpointConfiguration == null) continue;
                EndpointWrapper ew = new EndpointWrapper(serverEndpointConfiguration.getEndpointClass(), (EndpointConfiguration)serverEndpointConfiguration, this.componentProvider, (WebSocketContainer)this, this.contextPath, this.collector, serverEndpointConfiguration.getServerEndpointConfigurator());
                this.deploy(ew);
            }
        }
        catch (DeploymentException de) {
            this.collector.addException((Exception)((Object)de));
        }
        if (!this.collector.isEmpty()) {
            this.stop();
            throw this.collector.composeComprehensiveException();
        }
    }

    private void deploy(EndpointWrapper wrapper) {
        SPIRegisteredEndpoint ge = this.server.register((SPIEndpoint)wrapper);
        this.endpoints.add(ge);
    }

    public void stop() {
        for (SPIRegisteredEndpoint wsa : this.endpoints) {
            wsa.remove();
            this.server.unregister(wsa);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Closing down : " + wsa);
        }
        this.server.stop();
    }

    public Session connectToServer(Class annotatedEndpointClass, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfiguration cec, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.maxBinaryMessageBufferSize = max;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.maxTextMessageBufferSize = max;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout = timeoutmillis;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long defaultMaxSessionIdleTimeout) {
        this.defaultMaxSessionIdleTimeout = defaultMaxSessionIdleTimeout;
    }
}

