/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.CloseReason;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.websockets.WebSocket;

public class TyrusRemoteEndpoint
extends SPIRemoteEndpoint {
    private final WebSocket socket;
    private static final ConcurrentHashMap<WebSocket, TyrusRemoteEndpoint> sockets = new ConcurrentHashMap();

    public TyrusRemoteEndpoint(WebSocket socket) {
        this.socket = socket;
    }

    public static TyrusRemoteEndpoint get(WebSocket socket) {
        TyrusRemoteEndpoint s = sockets.get(socket);
        if (s == null) {
            s = new TyrusRemoteEndpoint(socket);
            sockets.put(socket, s);
        }
        return s;
    }

    public static void remove(WebSocket socket) {
        sockets.remove(socket);
    }

    public void sendText(String text) throws IOException {
        this.socket.send(text);
    }

    public void sendBinary(ByteBuffer byteBuffer) throws IOException {
        this.socket.send(byteBuffer.array());
    }

    public void sendText(String fragment, boolean isLast) throws IOException {
        this.socket.stream(isLast, fragment);
    }

    public void sendBinary(ByteBuffer byteBuffer, boolean b) throws IOException {
        byte[] bytes = byteBuffer.array();
        this.socket.stream(b, bytes, 0, bytes.length);
    }

    public void sendPing(ByteBuffer byteBuffer) {
        this.socket.sendPing(byteBuffer.array());
    }

    public void sendPong(ByteBuffer byteBuffer) {
        this.socket.sendPong(byteBuffer.array());
    }

    public void close(CloseReason closeReason) {
        this.socket.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }
}

