/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ReflectionHelper;

public class TyrusServerConfiguration
implements ServerApplicationConfig {
    private static final Logger LOGGER = Logger.getLogger(TyrusServerConfiguration.class.getName());
    private final Set<ServerEndpointConfig> serverEndpointConfigs = new HashSet<ServerEndpointConfig>();
    private final Set<Class<?>> annotatedClasses = new HashSet();

    public TyrusServerConfiguration(Set<Class<?>> classes, Set<ServerEndpointConfig> serverEndpointConfigs) {
        this(classes, Collections.emptySet(), serverEndpointConfigs, new ErrorCollector());
    }

    public TyrusServerConfiguration(Set<Class<?>> classes, Set<Class<?>> dynamicallyAddedClasses, Set<ServerEndpointConfig> serverEndpointConfigs, ErrorCollector errorCollector) {
        if (classes == null || serverEndpointConfigs == null || errorCollector == null) {
            throw new IllegalArgumentException();
        }
        this.serverEndpointConfigs.addAll(serverEndpointConfigs);
        HashSet<ServerApplicationConfig> configurations = new HashSet<ServerApplicationConfig>();
        HashSet scannedProgramatics = new HashSet();
        HashSet scannedAnnotateds = new HashSet();
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> cls = it.next();
            if (this.isAbstract(cls, errorCollector)) {
                it.remove();
                continue;
            }
            if (ServerApplicationConfig.class.isAssignableFrom(cls)) {
                ServerApplicationConfig config = (ServerApplicationConfig)ReflectionHelper.getInstance(cls, (ErrorCollector)errorCollector);
                configurations.add(config);
            }
            if (Endpoint.class.isAssignableFrom(cls)) {
                scannedProgramatics.add(cls);
            }
            if (!cls.isAnnotationPresent(ServerEndpoint.class)) continue;
            scannedAnnotateds.add(cls);
        }
        for (Class<?> c : dynamicallyAddedClasses) {
            if (this.isAbstract(c, errorCollector)) continue;
            if (c.isAnnotationPresent(ServerEndpoint.class)) {
                this.annotatedClasses.add(c);
                continue;
            }
            errorCollector.addException((Exception)((Object)new DeploymentException(String.format("Class %s is not ServerApplicationConfig descendant nor has @ServerEndpoint annotation.", c.getName()))));
        }
        if (!configurations.isEmpty()) {
            for (ServerApplicationConfig configuration : configurations) {
                Set programmatic = configuration.getEndpointConfigs(scannedProgramatics);
                programmatic = programmatic == null ? new HashSet() : programmatic;
                this.serverEndpointConfigs.addAll(programmatic);
                Set annotated = configuration.getAnnotatedEndpointClasses(scannedAnnotateds);
                annotated = annotated == null ? new HashSet() : annotated;
                this.annotatedClasses.addAll(annotated);
            }
        } else {
            this.annotatedClasses.addAll(scannedAnnotateds);
        }
    }

    private boolean isAbstract(Class<?> clazz, ErrorCollector errorCollector) {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            LOGGER.log(Level.WARNING, String.format("%s: Deployed class can't be abstract nor interface. The class will not be deployed.", clazz.getName()));
            return true;
        }
        return false;
    }

    public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> scanned) {
        return Collections.unmodifiableSet(this.serverEndpointConfigs);
    }

    public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
        return Collections.unmodifiableSet(this.annotatedClasses);
    }
}

