/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.websocket.annotations.WebSocketClose;
import javax.net.websocket.annotations.WebSocketEndpoint;
import javax.net.websocket.annotations.WebSocketMessage;
import javax.net.websocket.annotations.WebSocketOpen;

public class Model {
    private Set<Method> onOpenMethods;
    private Set<Method> onCloseMethods;
    private Set<Method> onMessageMethods;
    private Set<Class<?>> encoders;
    private Set<Class<?>> decoders;
    private Field contextField;
    private List<String> subprotocols;
    private Object myBean;

    public Model(Class<?> annotatedClass) {
        this(annotatedClass, null);
    }

    public Model(Object endpoint) throws IllegalAccessException, InstantiationException {
        this(endpoint.getClass(), endpoint);
    }

    private Model(Class<?> annotatedClass, Object instance) {
        this.onOpenMethods = Model.parseAnnotatedMethods(annotatedClass, WebSocketOpen.class);
        this.onCloseMethods = Model.parseAnnotatedMethods(annotatedClass, WebSocketClose.class);
        this.onMessageMethods = Model.parseAnnotatedMethods(annotatedClass, WebSocketMessage.class);
        this.encoders = this.parseEncoders(annotatedClass);
        this.decoders = this.parseDecoders(annotatedClass);
        this.subprotocols = Model.parseSubprotocols(annotatedClass);
        if (instance == null) {
            try {
                this.myBean = annotatedClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            this.myBean = instance;
        }
    }

    private Set<Class<?>> parseDecoders(Class wsClass) {
        HashSet decs = new HashSet();
        WebSocketEndpoint wsClassAnnotation = wsClass.getAnnotation(WebSocketEndpoint.class);
        if (wsClassAnnotation != null) {
            for (Class decoder : wsClassAnnotation.decoders()) {
                decs.add(decoder);
            }
        }
        return decs;
    }

    private Set<Class<?>> parseEncoders(Class wsClass) {
        HashSet encs = new HashSet();
        WebSocketEndpoint wsClassAnnotation = wsClass.getAnnotation(WebSocketEndpoint.class);
        if (wsClassAnnotation != null) {
            for (Class encoder : wsClassAnnotation.encoders()) {
                encs.add(encoder);
            }
        }
        return encs;
    }

    public static Set<Method> parseAnnotatedMethods(Class wsClass, Class annotationClass) {
        HashSet<Method> meths = new HashSet<Method>();
        for (Method m : wsClass.getDeclaredMethods()) {
            if (m.getAnnotation(annotationClass) == null) continue;
            meths.add(m);
        }
        return meths;
    }

    public static List<String> parseSubprotocols(Class wsClass) {
        WebSocketEndpoint ws = wsClass.getAnnotation(WebSocketEndpoint.class);
        if (ws != null) {
            return Arrays.asList(ws.subprotocols());
        }
        return Collections.emptyList();
    }

    public Set<Method> getOnOpenMethods() {
        return this.onOpenMethods;
    }

    public Set<Method> getOnCloseMethods() {
        return this.onCloseMethods;
    }

    public Set<Method> getOnMessageMethods() {
        return this.onMessageMethods;
    }

    public Object getBean() {
        return this.myBean;
    }

    public Set<Class<?>> getEncoders() {
        return this.encoders;
    }

    public Set<Class<?>> getDecoders() {
        return this.decoders;
    }

    public Field getContextField() {
        return this.contextField;
    }

    public List<String> getSubprotocols() {
        return this.subprotocols;
    }
}

