/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.net.websocket.CloseReason;
import javax.net.websocket.EncodeException;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.SendHandler;
import javax.net.websocket.SendResult;
import javax.net.websocket.Session;
import org.glassfish.tyrus.platform.SessionImpl;
import org.glassfish.tyrus.platform.WebSocketEndpointImpl;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;

public final class RemoteEndpointWrapper<T>
implements RemoteEndpoint<T> {
    private final SPIRemoteEndpoint providedRemoteEndpoint;
    private final SessionImpl webSocketSession;
    private final WebSocketEndpointImpl correspondingEndpoint;
    private String connectedToAddress;
    private static ConcurrentHashMap<SPIRemoteEndpoint, RemoteEndpointWrapper> wrappers = new ConcurrentHashMap();

    public static RemoteEndpointWrapper getRemoteWrapper(SPIRemoteEndpoint socket, WebSocketEndpointImpl application, boolean serverEndpoint) {
        RemoteEndpointWrapper result = wrappers.get(socket);
        if (result == null) {
            result = new RemoteEndpointWrapper(socket, application);
            wrappers.put(socket, result);
        }
        return result;
    }

    private RemoteEndpointWrapper(SPIRemoteEndpoint providedRemoteEndpoint, WebSocketEndpointImpl correspondingEndpoint) {
        this.providedRemoteEndpoint = providedRemoteEndpoint;
        this.correspondingEndpoint = correspondingEndpoint;
        this.webSocketSession = new SessionImpl();
        this.webSocketSession.setPeer(this);
    }

    public String getAddress() {
        return this.connectedToAddress;
    }

    public boolean isConnected() {
        return this.providedRemoteEndpoint.isConnected();
    }

    @Override
    public void sendString(String data) throws IOException {
        this.providedRemoteEndpoint.send(data);
    }

    @Override
    public void sendBytes(byte[] data) throws IOException {
        this.providedRemoteEndpoint.send(data);
    }

    @Override
    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void sendPartialBytes(byte[] partialByte, boolean isLast) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public OutputStream getSendStream() throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Writer getSendWriter() throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void sendObject(T o) throws IOException, EncodeException {
        this.sendPolymorphic(o);
    }

    @Override
    public Future<SendResult> sendString(String text, SendHandler completion) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Future<SendResult> sendBytes(byte[] data, SendHandler completion) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Future<SendResult> sendObject(T o, SendHandler handler) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void sendPing(byte[] applicationData) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void sendPong(byte[] applicationData) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        return "Wrapped: " + this.getClass().getSimpleName();
    }

    void setAddress(String clientAddress) {
        this.connectedToAddress = clientAddress;
    }

    void discard() {
        wrappers.remove(this.providedRemoteEndpoint);
    }

    private void sendPrimitiveMessage(Object data) throws IOException, EncodeException {
        if (!this.isPrimitiveData(data)) {
            throw new EncodeException("object " + data + " is not a primitive type.", data);
        }
        this.sendString(data.toString());
    }

    private void sendPolymorphic(Object o) throws IOException, EncodeException {
        if (o instanceof String) {
            this.sendString((String)o);
        } else if (this.isPrimitiveData(o)) {
            this.sendPrimitiveMessage(o);
        } else {
            String stringToSend = this.correspondingEndpoint.doEncode(o);
            this.sendString(stringToSend);
        }
    }

    private boolean isPrimitiveData(Object data) {
        Class<?> dataClass = data.getClass();
        return dataClass.equals(Integer.class) || dataClass.equals(Byte.class) || dataClass.equals(Short.class) || dataClass.equals(Long.class) || dataClass.equals(Float.class) || dataClass.equals(Double.class) || dataClass.equals(Boolean.class) || dataClass.equals(Character.class);
    }

    public void close(CloseReason cr) throws IOException {
        this.providedRemoteEndpoint.close(1000, null);
    }

    public Session getSession() {
        return this.webSocketSession;
    }
}

