/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.spi.grizzlyprovider;

import java.util.List;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.spi.grizzlyprovider.GrizzlyHandshakeRequest;
import org.glassfish.tyrus.spi.grizzlyprovider.GrizzlyRemoteEndpoint;
import org.glassfish.tyrus.spi.grizzlyprovider.GrizzlySocket;

class GrizzlyEndpoint
extends WebSocketApplication
implements SPIRegisteredEndpoint {
    private SPIEndpoint endpoint;

    GrizzlyEndpoint(SPIEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isApplicationRequest(HttpRequestPacket o) {
        return this.endpoint.checkHandshake(new GrizzlyHandshakeRequest(o));
    }

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        return new GrizzlySocket(handler, requestPacket, listeners);
    }

    public void onConnect(WebSocket socket) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        this.endpoint.onConnect(gs);
    }

    public void onMessage(WebSocket socket, String messageString) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        this.endpoint.onMessage((SPIRemoteEndpoint)gs, messageString);
    }

    public void onClose(WebSocket socket, DataFrame frame) {
        GrizzlyRemoteEndpoint gs = GrizzlyRemoteEndpoint.get(socket);
        this.endpoint.onClose(gs);
        GrizzlyRemoteEndpoint.remove(socket);
    }

    @Override
    public void remove() {
        this.endpoint.remove();
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        return this.endpoint.getSupportedProtocols(subProtocol);
    }
}

