/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.spi.grizzlyprovider;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.spi.grizzlyprovider.GrizzlySocket;

public class GrizzlyRemoteEndpoint
implements SPIRemoteEndpoint {
    private WebSocket socket;
    private static ConcurrentHashMap<WebSocket, GrizzlyRemoteEndpoint> sockets = new ConcurrentHashMap();

    public GrizzlyRemoteEndpoint(WebSocket socket) {
        this.socket = socket;
    }

    public static GrizzlyRemoteEndpoint get(WebSocket socket) {
        GrizzlyRemoteEndpoint s = sockets.get(socket);
        if (s == null) {
            s = new GrizzlyRemoteEndpoint(socket);
            sockets.put(socket, s);
        }
        return s;
    }

    public static void remove(WebSocket socket) {
        sockets.remove(socket);
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public void send(String data) throws IOException {
        try {
            this.socket.send(data);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    @Override
    public void send(byte[] data) throws IOException {
        this.socket.send(data);
    }

    @Override
    public void close(int code, String reason) throws IOException {
        this.socket.close(code, reason);
    }

    @Override
    public String getUri() {
        if (this.socket instanceof GrizzlySocket) {
            return ((GrizzlySocket)this.socket).getRequest().getRequestURI();
        }
        return null;
    }
}

