/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import javax.net.websocket.Endpoint;
import javax.net.websocket.ServerContainer;
import org.glassfish.tyrus.platform.MessageHandlerTextImpl;
import org.glassfish.tyrus.platform.SessionImpl;
import org.glassfish.tyrus.platform.WebSocketEndpointImpl;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;

public class WebSocketEndpointAdapter
extends WebSocketEndpointImpl {
    private Endpoint endpoint;

    WebSocketEndpointAdapter(ServerContainer containerContext, Endpoint endpoint, String path) {
        super(containerContext, path, null);
        this.endpoint = endpoint;
    }

    void init() {
    }

    @Override
    public void onConnect(SPIRemoteEndpoint gs) {
        super.onConnect(gs);
        this.getPeer(gs).getSession().addMessageHandler(new MessageHandlerTextImpl(this.endpoint, this.getPeer(gs)));
        this.endpoint.onOpen(this.getPeer(gs).getSession());
    }

    @Override
    public void onMessage(SPIRemoteEndpoint gs, String messageString) {
        ((SessionImpl)this.getPeer(gs).getSession()).notifyMessageHandlers(messageString);
    }

    @Override
    public void onMessage(SPIRemoteEndpoint gs, byte[] data) {
        ((SessionImpl)this.getPeer(gs).getSession()).notifyMessageHandlers(data);
    }

    @Override
    public void onClose(SPIRemoteEndpoint gs) {
        super.onClose(gs);
        this.endpoint.onClose(this.getPeer(gs).getSession());
    }

    @Override
    public void remove() {
    }
}

