/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.net.websocket.annotations.WebSocketEndpoint;
import org.glassfish.tyrus.platform.DefaultServerEndpointConfiguration;
import org.glassfish.tyrus.platform.EndpointWrapper;
import org.glassfish.tyrus.platform.Model;
import org.glassfish.tyrus.platform.ServerContainerImpl;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.SPIWebSocketProvider;

public class BeanServer {
    Set<SPIRegisteredEndpoint> endpoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private ServerContainerImpl containerContext;
    private SPIWebSocketProvider engine;
    static final Logger logger = Logger.getLogger("wsplatform");

    public BeanServer(String engineProviderClassname) {
        try {
            Class<?> engineProviderClazz = Class.forName(engineProviderClassname);
            this.setEngine((SPIWebSocketProvider)engineProviderClazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load provider class: " + engineProviderClassname + ". The provider class defaults to" + "the grizzly provider. If you wish to provide your own implementation of the provider SPI, you can configure" + "the provider class in the web.xml of the application using a" + "context initialization parameter with key org.glassfish.websocket.provider.class, and using the full classname as the value.");
        }
        logger.info("Provider class loaded: " + engineProviderClassname);
    }

    private void setEngine(SPIWebSocketProvider engine) {
        this.engine = engine;
        logger.info("Provider class instance: " + engine + " of class " + this.engine.getClass() + " assigned in the BeanServer");
    }

    public ServerContainerImpl getContainerContext() {
        return this.containerContext;
    }

    public void closeWebSocketServer() {
        for (SPIRegisteredEndpoint wsa : this.endpoints) {
            wsa.remove();
            this.engine.unregister(wsa);
            logger.info("Closing down : " + wsa);
        }
    }

    public void initWebSocketServer(String wsPath, int port, Set<Class<?>> fqWSBeanNames) throws Exception {
        this.containerContext = new ServerContainerImpl(this, wsPath, port);
        for (Class<?> webSocketApplicationBeanClazz : fqWSBeanNames) {
            this.containerContext.setApplicationLevelClassLoader(webSocketApplicationBeanClazz.getClassLoader());
            Map<Method, String> methodPathMap = this.getMethodToPathMap(webSocketApplicationBeanClazz);
            if (methodPathMap.isEmpty()) {
                logger.warning(webSocketApplicationBeanClazz + " has no path mappings");
            }
            HashSet<String> allPathsForBean = new HashSet<String>(methodPathMap.values());
            for (String nextPath : allPathsForBean) {
                Model model = new Model(webSocketApplicationBeanClazz);
                String wrapperBeanPath = (wsPath.endsWith("/") ? wsPath.substring(0, wsPath.length() - 1) : wsPath) + "/" + (nextPath.startsWith("/") ? nextPath.substring(1) : nextPath);
                EndpointWrapper endpoint = new EndpointWrapper(wrapperBeanPath, model, new DefaultServerEndpointConfiguration(model));
                this.deploy(endpoint);
            }
        }
    }

    void deploy(EndpointWrapper wsa) {
        SPIRegisteredEndpoint ge = this.engine.register(wsa);
        this.endpoints.add(ge);
        logger.info("Registered a " + wsa.getClass() + " at " + wsa.getPath());
    }

    private Map<Method, String> getMethodToPathMap(Class beanClazz) throws Exception {
        Method[] methods;
        HashMap<Method, String> pathMappings = new HashMap<Method, String>();
        for (Method method : methods = beanClazz.getDeclaredMethods()) {
            WebSocketEndpoint wsClass = beanClazz.getAnnotation(WebSocketEndpoint.class);
            pathMappings.put(method, wsClass.value());
        }
        return pathMappings;
    }
}

