/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.websocket.CloseReason;
import javax.net.websocket.DecodeException;
import javax.net.websocket.Decoder;
import javax.net.websocket.EncodeException;
import javax.net.websocket.Encoder;
import javax.net.websocket.Endpoint;
import javax.net.websocket.EndpointConfiguration;
import javax.net.websocket.MessageHandler;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.Session;
import org.glassfish.tyrus.platform.Model;
import org.glassfish.tyrus.platform.RemoteEndpointWrapper;
import org.glassfish.tyrus.platform.utils.PrimitivesToBoxing;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;

public class EndpointWrapper
extends SPIEndpoint {
    private EndpointConfiguration configuration;
    private final String path;
    private Model model;
    private ConcurrentHashMap<RemoteEndpoint, RemoteEndpointWrapper> wrappers = new ConcurrentHashMap();
    private boolean annotated;

    public EndpointWrapper(String path, Model model, EndpointConfiguration configuration) {
        this.path = path;
        this.model = model;
        this.configuration = configuration;
        this.annotated = model.wasAnnotated();
    }

    protected boolean doesPathMatch(String remoteUri, String dynamicPath) {
        if (dynamicPath.equals("*")) {
            return true;
        }
        return (this.path + dynamicPath).equals(remoteUri);
    }

    private Object decodeMessage(Object message, Class<?> type, boolean isString) throws DecodeException {
        for (Decoder dec : this.configuration.getDecoders()) {
            try {
                Method m;
                List<Class<?>> interfaces = Arrays.asList(dec.getClass().getInterfaces());
                if (isString && interfaces.contains(Decoder.Text.class)) {
                    m = dec.getClass().getDeclaredMethod("decode", String.class);
                    if (type == null || !type.equals(m.getReturnType()) || !((Decoder.Text)dec).willDecode((String)message)) continue;
                    return ((Decoder.Text)dec).decode((String)message);
                }
                if (isString || !interfaces.contains(Decoder.Binary.class)) continue;
                m = dec.getClass().getDeclaredMethod("decode", ByteBuffer.class);
                if (type == null || !type.equals(m.getReturnType()) || !((Decoder.Binary)dec).willDecode((ByteBuffer)message)) continue;
                return ((Decoder.Binary)dec).decode((ByteBuffer)message);
            }
            catch (DecodeException de) {
                de.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    String doEncode(Object o) throws EncodeException {
        for (Encoder enc : this.configuration.getEncoders()) {
            List<Class<?>> interfaces = Arrays.asList(enc.getClass().getInterfaces());
            if (!interfaces.contains(Encoder.Text.class)) continue;
            try {
                Method m = enc.getClass().getMethod("encode", o.getClass());
                if (m == null) continue;
                return ((Encoder.Text)enc).encode(o);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (EncodeException ee) {
                ee.printStackTrace();
                throw ee;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new EncodeException("Unable to encode ", o);
    }

    String getPath() {
        return this.path;
    }

    @Override
    public boolean checkHandshake(SPIHandshakeRequest hr) {
        return hr.getRequestURI().startsWith(this.path);
    }

    @Override
    public List<String> getSupportedProtocols(List<String> subProtocol) {
        ArrayList<String> supported = new ArrayList<String>();
        for (String nextRequestedProtocolName : subProtocol) {
            if (!this.model.getSubprotocols().contains(nextRequestedProtocolName)) continue;
            supported.add(nextRequestedProtocolName);
        }
        return supported;
    }

    @Override
    public void remove() {
    }

    @Override
    public void onConnect(RemoteEndpoint gs) {
        RemoteEndpointWrapper peer = this.getPeer(gs);
        peer.setAddress(null);
        this.onGeneratedBeanConnect(peer);
    }

    @Override
    public void onMessage(RemoteEndpoint gs, ByteBuffer messageBytes) {
        RemoteEndpointWrapper peer = this.getPeer(gs);
        peer.updateLastConnectionActivity();
        this.processCompleteMessage(gs, messageBytes, false);
    }

    @Override
    public void onMessage(RemoteEndpoint gs, String messageString) {
        RemoteEndpointWrapper peer = this.getPeer(gs);
        peer.updateLastConnectionActivity();
        this.processCompleteMessage(gs, messageString, true);
    }

    private void processCompleteMessage(RemoteEndpoint gs, Object o, boolean isString) {
        RemoteEndpointWrapper peer = this.getPeer(gs);
        boolean decoded = false;
        for (MessageHandler handler : peer.getSession().getMessageHandlers()) {
            if (isString) {
                if (!(handler instanceof MessageHandler.Text)) continue;
                ((MessageHandler.Text)handler).onMessage((String)o);
                decoded = true;
                continue;
            }
            if (!(handler instanceof MessageHandler.Binary)) continue;
            ((MessageHandler.Binary)handler).onMessage((ByteBuffer)o);
            decoded = true;
        }
        try {
            for (Method m : this.model.getOnMessageMethods()) {
                Object decodedMessageObject;
                Class<?>[] paramTypes = m.getParameterTypes();
                Class<?> type = null;
                for (Class<?> methodParamType : paramTypes) {
                    if (methodParamType.equals(Session.class)) continue;
                    type = PrimitivesToBoxing.getBoxing(methodParamType) == null ? methodParamType : PrimitivesToBoxing.getBoxing(methodParamType);
                    break;
                }
                if ((decodedMessageObject = this.decodeMessage(o, type, isString)) == null) continue;
                Object returned = this.invokeMethod(decodedMessageObject, m, peer);
                if (returned != null) {
                    if (o instanceof String) {
                        String messageToSendAsString = this.doEncode(returned);
                        peer.sendString(messageToSendAsString);
                    } else if (returned instanceof byte[]) {
                        peer.sendBytes((ByteBuffer)returned);
                    }
                }
                decoded = true;
            }
            if (!decoded) {
                throw new Exception();
            }
        }
        catch (IOException ioe) {
            this.handleGeneratedBeanException(peer, ioe);
        }
        catch (DecodeException de) {
            this.handleGeneratedBeanException(peer, de);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Error invoking message decoding");
        }
    }

    private Object invokeMethod(Object object, Method method, RemoteEndpointWrapper peer) throws Exception {
        Object result;
        Object param2;
        Object param1;
        Class<?>[] paramTypes = method.getParameterTypes();
        int noOfParameters = paramTypes.length;
        Object param0 = this.model.getBean();
        if (!this.parameterBelongsToMethod(method, object)) {
            return null;
        }
        if (paramTypes[0].equals(object.getClass()) || PrimitivesToBoxing.getBoxing(paramTypes[0]).equals(object.getClass())) {
            param1 = object;
            param2 = peer.getSession();
        } else {
            param1 = peer.getSession();
            param2 = object;
        }
        switch (noOfParameters) {
            case 1: {
                result = method.invoke(param0, param1);
                break;
            }
            case 2: {
                result = method.invoke(param0, param1, param2);
                break;
            }
            default: {
                throw new RuntimeException("can't deal with " + noOfParameters + " parameters.");
            }
        }
        return result;
    }

    private boolean parameterBelongsToMethod(Method method, Object parameter) {
        Class<?>[] paramTypes;
        for (Class<?> paramType : paramTypes = method.getParameterTypes()) {
            if (!PrimitivesToBoxing.getBoxing(paramType).equals(parameter.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onClose(RemoteEndpoint gs) {
        RemoteEndpointWrapper wsw = this.getPeer(gs);
        this.onGeneratedBeanClose(wsw);
        this.wrappers.remove(gs);
    }

    public void handleGeneratedBeanException(RemoteEndpoint peer, Exception e) {
        e.printStackTrace();
        throw new RuntimeException("Error handling not supported yet.");
    }

    public void onGeneratedBeanConnect(RemoteEndpointWrapper peer) {
        if (this.annotated) {
            for (Method m : this.model.getOnOpenMethods()) {
                try {
                    m.invoke(this.model.getBean(), peer.getSession());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error invoking it.");
                }
            }
        } else if (this.model.getBean() instanceof Endpoint) {
            ((Endpoint)this.model.getBean()).onOpen(peer.getSession());
        } else {
            try {
                throw new Exception("onConnect could not be invoked.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onGeneratedBeanClose(RemoteEndpointWrapper peer) {
        if (this.annotated) {
            for (Method m : this.model.getOnCloseMethods()) {
                try {
                    m.invoke(this.model.getBean(), peer.getSession());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error invoking it.");
                }
            }
        } else if (this.model.getBean() instanceof Endpoint) {
            ((Endpoint)this.model.getBean()).onClose(peer.getSession(), new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, "Normal Closure."));
        } else {
            try {
                throw new Exception("onClose could not be invoked.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected final RemoteEndpointWrapper getPeer(RemoteEndpoint gs) {
        RemoteEndpointWrapper result = this.wrappers.get(gs);
        if (result == null) {
            result = RemoteEndpointWrapper.getRemoteWrapper(gs, this);
        }
        this.wrappers.put(gs, result);
        return result;
    }
}

