/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.platform;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.websocket.Decoder;
import javax.net.websocket.Encoder;
import javax.net.websocket.annotations.WebSocketClose;
import javax.net.websocket.annotations.WebSocketEndpoint;
import javax.net.websocket.annotations.WebSocketMessage;
import javax.net.websocket.annotations.WebSocketOpen;
import org.glassfish.tyrus.platform.decoders.BinaryDecoderNoOp;
import org.glassfish.tyrus.platform.decoders.BooleanDecoder;
import org.glassfish.tyrus.platform.decoders.ByteDecoder;
import org.glassfish.tyrus.platform.decoders.CharDecoder;
import org.glassfish.tyrus.platform.decoders.DoubleDecoder;
import org.glassfish.tyrus.platform.decoders.FloatDecoder;
import org.glassfish.tyrus.platform.decoders.IntegerDecoder;
import org.glassfish.tyrus.platform.decoders.LongDecoder;
import org.glassfish.tyrus.platform.decoders.ShortDecoder;
import org.glassfish.tyrus.platform.decoders.StringDecoderNoOp;
import org.glassfish.tyrus.platform.encoders.BinaryEncoderNoOp;
import org.glassfish.tyrus.platform.encoders.BooleanEncoder;
import org.glassfish.tyrus.platform.encoders.ByteEncoder;
import org.glassfish.tyrus.platform.encoders.CharEncoder;
import org.glassfish.tyrus.platform.encoders.DoubleEncoder;
import org.glassfish.tyrus.platform.encoders.FloatEncoder;
import org.glassfish.tyrus.platform.encoders.IntegerEncoder;
import org.glassfish.tyrus.platform.encoders.LongEncoder;
import org.glassfish.tyrus.platform.encoders.ShortEncoder;
import org.glassfish.tyrus.platform.encoders.StringEncoderNoOp;

public class Model {
    private Set<Method> onOpenMethods;
    private Set<Method> onCloseMethods;
    private Set<Method> onMessageMethods;
    private List<Encoder> encoders;
    private List<Decoder> decoders;
    private List<String> subprotocols;
    private Object myBean;
    private boolean annotated = false;

    public Model(Class<?> annotatedClass) {
        this(annotatedClass, null);
    }

    public Model(Object endpoint) throws IllegalAccessException, InstantiationException {
        this(endpoint.getClass(), endpoint);
    }

    private Model(Class<?> annotatedClass, Object instance) {
        this.onOpenMethods = Model.parseAnnotatedMethods(annotatedClass, WebSocketOpen.class);
        this.onCloseMethods = Model.parseAnnotatedMethods(annotatedClass, WebSocketClose.class);
        this.onMessageMethods = Model.parseAnnotatedMethods(annotatedClass, WebSocketMessage.class);
        this.initEncoders(this.parseEncoders(annotatedClass));
        this.initDecoders(this.parseDecoders(annotatedClass));
        this.subprotocols = Model.parseSubprotocols(annotatedClass);
        if (instance == null) {
            this.annotated = true;
            try {
                this.myBean = annotatedClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            this.myBean = instance;
        }
    }

    private Set<Class<?>> parseDecoders(Class wsClass) {
        HashSet decs = new HashSet();
        WebSocketEndpoint wsClassAnnotation = wsClass.getAnnotation(WebSocketEndpoint.class);
        if (wsClassAnnotation != null) {
            for (Class decoder : wsClassAnnotation.decoders()) {
                decs.add(decoder);
            }
        }
        return decs;
    }

    private Set<Class<?>> parseEncoders(Class wsClass) {
        HashSet encs = new HashSet();
        WebSocketEndpoint wsClassAnnotation = wsClass.getAnnotation(WebSocketEndpoint.class);
        if (wsClassAnnotation != null) {
            for (Class encoder : wsClassAnnotation.encoders()) {
                encs.add(encoder);
            }
        }
        return encs;
    }

    public static Set<Method> parseAnnotatedMethods(Class wsClass, Class annotationClass) {
        HashSet<Method> meths = new HashSet<Method>();
        for (Method m : wsClass.getDeclaredMethods()) {
            if (m.getAnnotation(annotationClass) == null) continue;
            meths.add(m);
        }
        return meths;
    }

    public static List<String> parseSubprotocols(Class wsClass) {
        WebSocketEndpoint ws = wsClass.getAnnotation(WebSocketEndpoint.class);
        if (ws != null) {
            return Arrays.asList(ws.subprotocols());
        }
        return Collections.emptyList();
    }

    private void initEncoders(Set<Class<?>> clientEncoders) {
        this.encoders = new ArrayList<Encoder>();
        if (clientEncoders != null) {
            for (Class<?> encoderClass : clientEncoders) {
                try {
                    Object encoder = encoderClass.newInstance();
                    if (encoder instanceof Encoder) {
                        this.encoders.add((Encoder)encoder);
                        continue;
                    }
                    throw new Exception("Provided encoder does not implement Encoder interface");
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.encoders.add(new StringEncoderNoOp());
        this.encoders.add(new BinaryEncoderNoOp());
        this.encoders.add(new BooleanEncoder());
        this.encoders.add(new ByteEncoder());
        this.encoders.add(new CharEncoder());
        this.encoders.add(new DoubleEncoder());
        this.encoders.add(new FloatEncoder());
        this.encoders.add(new IntegerEncoder());
        this.encoders.add(new LongEncoder());
        this.encoders.add(new ShortEncoder());
    }

    private void initDecoders(Set<Class<?>> clientDecoders) {
        this.decoders = new ArrayList<Decoder>();
        if (clientDecoders != null) {
            for (Class<?> encoderClass : clientDecoders) {
                try {
                    Object decoder = encoderClass.newInstance();
                    if (decoder instanceof Decoder) {
                        this.decoders.add((Decoder)decoder);
                        continue;
                    }
                    throw new Exception("Provided encoder does not implement Decoder interface");
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.decoders.add(new StringDecoderNoOp());
        this.decoders.add(new BinaryDecoderNoOp());
        this.decoders.add(new BooleanDecoder());
        this.decoders.add(new ByteDecoder());
        this.decoders.add(new IntegerDecoder());
        this.decoders.add(new LongDecoder());
        this.decoders.add(new ShortDecoder());
        this.decoders.add(new FloatDecoder());
        this.decoders.add(new DoubleDecoder());
        this.decoders.add(new CharDecoder());
    }

    public Set<Method> getOnOpenMethods() {
        return this.onOpenMethods;
    }

    public Set<Method> getOnCloseMethods() {
        return this.onCloseMethods;
    }

    public Set<Method> getOnMessageMethods() {
        return this.onMessageMethods;
    }

    public Object getBean() {
        return this.myBean;
    }

    public List<Encoder> getEncoders() {
        return this.encoders;
    }

    public List<Decoder> getDecoders() {
        return this.decoders;
    }

    public List<String> getSubprotocols() {
        return this.subprotocols;
    }

    public boolean wasAnnotated() {
        return this.annotated;
    }
}

