/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.spi.grizzlyprovider;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.net.websocket.EncodeException;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.SendHandler;
import javax.net.websocket.SendResult;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.tyrus.spi.grizzlyprovider.GrizzlySocket;

public class GrizzlyRemoteEndpoint
implements RemoteEndpoint {
    private WebSocket socket;
    private static ConcurrentHashMap<WebSocket, GrizzlyRemoteEndpoint> sockets = new ConcurrentHashMap();

    public GrizzlyRemoteEndpoint(WebSocket socket) {
        this.socket = socket;
    }

    public static GrizzlyRemoteEndpoint get(WebSocket socket) {
        GrizzlyRemoteEndpoint s = sockets.get(socket);
        if (s == null) {
            s = new GrizzlyRemoteEndpoint(socket);
            sockets.put(socket, s);
        }
        return s;
    }

    public static void remove(WebSocket socket) {
        sockets.remove(socket);
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public String getUri() {
        if (this.socket instanceof GrizzlySocket) {
            return ((GrizzlySocket)this.socket).getRequest().getRequestURI();
        }
        return null;
    }

    @Override
    public void sendString(String text) throws IOException {
        this.socket.send(text);
    }

    @Override
    public void sendBytes(ByteBuffer byteBuffer) throws IOException {
    }

    @Override
    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        this.socket.stream(isLast, fragment);
    }

    @Override
    public void sendPartialBytes(ByteBuffer byteBuffer, boolean b) throws IOException {
    }

    @Override
    public OutputStream getSendStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer getSendWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void sendObject(Object o) throws IOException, EncodeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<SendResult> sendString(String text, SendHandler completion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<SendResult> sendBytes(ByteBuffer byteBuffer, SendHandler sendHandler) {
        return null;
    }

    public Future<SendResult> sendObject(Object o, SendHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendPing(ByteBuffer byteBuffer) {
    }

    @Override
    public void sendPong(ByteBuffer byteBuffer) {
    }
}

