/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.websocket.CloseReason;
import javax.net.websocket.Endpoint;
import javax.net.websocket.MessageHandler;
import javax.net.websocket.Session;
import javax.net.websocket.annotations.WebSocketClose;
import javax.net.websocket.annotations.WebSocketError;
import javax.net.websocket.annotations.WebSocketMessage;
import javax.net.websocket.annotations.WebSocketOpen;
import javax.net.websocket.annotations.WebSocketPathParam;
import org.glassfish.tyrus.DecodedObjectMessageHandler;
import org.glassfish.tyrus.PrimitivesToBoxing;
import org.glassfish.tyrus.SessionImpl;

public class AnnotatedEndpoint
extends Endpoint {
    private static final Logger LOGGER = Logger.getLogger(AnnotatedEndpoint.class.getName());
    private final Object annotatedInstance;
    private final Method onOpenMethod;
    private final Method onCloseMethod;
    private final Method onErrorMethod;
    private final ParameterExtractor[] onOpenParameters;
    private final ParameterExtractor[] onCloseParameters;
    private final ParameterExtractor[] onErrorParameters;
    private Set<MessageHandlerFactory> messageHandlerFactories = new HashSet<MessageHandlerFactory>();

    public AnnotatedEndpoint(Class<?> annotatedClass) {
        try {
            this.annotatedInstance = annotatedClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate endpoint class: " + annotatedClass, e);
        }
        Method onOpen = null;
        Method onClose = null;
        Method onError = null;
        ParameterExtractor[] onOpenParameters = null;
        ParameterExtractor[] onCloseParameters = null;
        ParameterExtractor[] onErrorParameters = null;
        HashMap unknownParams = new HashMap();
        for (Method m : annotatedClass.getDeclaredMethods()) {
            for (Annotation a : m.getAnnotations()) {
                if (a instanceof WebSocketOpen) {
                    if (onOpen == null) {
                        onOpen = m;
                        onOpenParameters = this.getParameterExtractors(m, unknownParams);
                        if (unknownParams.isEmpty()) continue;
                        LOGGER.warning("Unknown parameter(s) for " + annotatedClass.getName() + "." + m.getName() + " method annotated with @WebSocketOpen annotation: " + unknownParams + ". This" + " method will be ignored.");
                        onOpen = null;
                        onOpenParameters = null;
                        continue;
                    }
                    LOGGER.warning("Multiple methods using @WebSocketOpen annotation in class " + annotatedClass.getName() + ": " + onOpen.getName() + " and " + m.getName() + ". The latter will be ignored.");
                    continue;
                }
                if (a instanceof WebSocketClose) {
                    if (onClose == null) {
                        onClose = m;
                        onCloseParameters = this.getParameterExtractors(m, unknownParams);
                        if (unknownParams.size() == 1 && unknownParams.values().iterator().next() != CloseReason.class) {
                            onCloseParameters[((Integer)unknownParams.keySet().iterator().next()).intValue()] = new ParamValue(0);
                            continue;
                        }
                        if (unknownParams.isEmpty()) continue;
                        LOGGER.warning("Unknown parameter(s) for " + annotatedClass.getName() + "." + m.getName() + " method annotated with @WebSocketClose annotation: " + unknownParams + ". This" + " method will be ignored.");
                        onClose = null;
                        onCloseParameters = null;
                        continue;
                    }
                    LOGGER.warning("Multiple methods using @WebSocketClose annotation in class " + annotatedClass.getName() + ": " + onClose.getName() + " and " + m.getName() + ". The latter will be ignored.");
                    continue;
                }
                if (a instanceof WebSocketError) {
                    if (onError == null) {
                        onError = m;
                        onErrorParameters = this.getParameterExtractors(m, unknownParams);
                        if (unknownParams.size() == 1 && Throwable.class == unknownParams.values().iterator().next()) {
                            onErrorParameters[((Integer)unknownParams.keySet().iterator().next()).intValue()] = new ParamValue(0);
                            continue;
                        }
                        if (unknownParams.isEmpty()) continue;
                        LOGGER.warning("Unknown parameter(s) for " + annotatedClass.getName() + "." + m.getName() + " method annotated with @WebSocketError annotation: " + unknownParams + ". This" + " method will be ignored.");
                        onError = null;
                        onErrorParameters = null;
                        continue;
                    }
                    LOGGER.warning("Multiple methods using @WebSocketError annotation in class " + annotatedClass.getName() + ": " + onError.getName() + " and " + m.getName() + ". The latter will be ignored.");
                    continue;
                }
                if (!(a instanceof WebSocketMessage)) continue;
                ParameterExtractor[] extractors = this.getParameterExtractors(m, unknownParams);
                if (unknownParams.isEmpty()) {
                    LOGGER.warning("Method " + annotatedClass.getName() + "." + m.getName() + " is annotated with " + "@WebSocketMessage annotation but does not have any parameter representing the" + " message. This method will be ignored.");
                    continue;
                }
                if (unknownParams.size() == 1) {
                    Map.Entry entry = unknownParams.entrySet().iterator().next();
                    extractors[((Integer)entry.getKey()).intValue()] = new ParamValue(0);
                    if (entry.getValue() == String.class) {
                        this.messageHandlerFactories.add(new Text(m, extractors));
                        continue;
                    }
                    if (entry.getValue() == ByteBuffer.class) {
                        this.messageHandlerFactories.add(new Binary(m, extractors));
                        continue;
                    }
                    if (entry.getValue() == InputStream.class) {
                        this.messageHandlerFactories.add(new BinaryStream(m, extractors));
                        continue;
                    }
                    if (entry.getValue() == Reader.class) {
                        this.messageHandlerFactories.add(new CharacterStream(m, extractors));
                        continue;
                    }
                    this.messageHandlerFactories.add(new DecodedObject(m, extractors, (Class)entry.getValue()));
                    continue;
                }
                if (unknownParams.size() == 2) {
                    Map.Entry last;
                    Iterator it = unknownParams.entrySet().iterator();
                    Map.Entry message = it.next();
                    if (message.getValue() == Boolean.TYPE || message.getValue() == Boolean.class) {
                        last = message;
                        message = it.next();
                    } else {
                        last = it.next();
                    }
                    extractors[((Integer)message.getKey()).intValue()] = new ParamValue(0);
                    extractors[((Integer)last.getKey()).intValue()] = new ParamValue(1);
                    if (last.getValue() == Boolean.TYPE || last.getValue() == Boolean.class) {
                        if (message.getValue() == String.class) {
                            this.messageHandlerFactories.add(new AsyncText(m, extractors));
                            continue;
                        }
                        if (message.getValue() == ByteBuffer.class) {
                            this.messageHandlerFactories.add(new AsyncBinary(m, extractors));
                            continue;
                        }
                    }
                }
                LOGGER.warning("Method " + annotatedClass.getName() + "." + m.getName() + " annotated with " + "@WebSocketMessage annotation has unknown parameters: " + unknownParams + ". This " + "method will be ignored.");
            }
        }
        this.onOpenMethod = onOpen;
        this.onErrorMethod = onError;
        this.onCloseMethod = onClose;
        this.onOpenParameters = onOpenParameters;
        this.onErrorParameters = onErrorParameters;
        this.onCloseParameters = onCloseParameters;
    }

    private ParameterExtractor[] getParameterExtractors(Method method, Map<Integer, Class<?>> unknownParams) {
        ParameterExtractor[] result = new ParameterExtractor[method.getParameterTypes().length];
        unknownParams.clear();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> type = method.getParameterTypes()[i];
            final String pathParamName = this.getPathParamName(method.getParameterAnnotations()[i]);
            if (pathParamName != null) {
                result[i] = new ParameterExtractor(){

                    @Override
                    public Object value(Session session, Object ... values) {
                        return ((SessionImpl)session).getPathParameters().get(pathParamName);
                    }
                };
                continue;
            }
            if (type == Session.class) {
                result[i] = new ParameterExtractor(){

                    @Override
                    public Object value(Session session, Object ... values) {
                        return session;
                    }
                };
                continue;
            }
            unknownParams.put(i, type);
        }
        return result;
    }

    private String getPathParamName(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof WebSocketPathParam)) continue;
            return ((WebSocketPathParam)a).value();
        }
        return null;
    }

    private Object callMethod(Method method, ParameterExtractor[] extractors, Session session, Object ... params) {
        if (method != null) {
            Object endpoint = this.annotatedInstance;
            Object[] paramValues = new Object[extractors.length];
            for (int i = 0; i < paramValues.length; ++i) {
                paramValues[i] = extractors[i].value(session, params);
            }
            try {
                return method.invoke(endpoint, paramValues);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        this.callMethod(this.onCloseMethod, this.onCloseParameters, session, closeReason);
    }

    @Override
    public void onError(Throwable thr, Session session) {
        this.callMethod(this.onErrorMethod, this.onErrorParameters, session, thr);
    }

    @Override
    public void onOpen(Session session) {
        for (MessageHandlerFactory f : this.messageHandlerFactories) {
            session.addMessageHandler(f.create(session));
        }
        this.callMethod(this.onOpenMethod, this.onOpenParameters, session, new Object[0]);
    }

    class DecodedObject
    extends MessageHandlerFactory {
        private final Class<?> type;

        DecodedObject(Method method, ParameterExtractor[] extractors, Class<?> type) {
            super(method, extractors);
            this.type = PrimitivesToBoxing.getBoxing(type) == null ? type : PrimitivesToBoxing.getBoxing(type);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new DecodedObjectMessageHandler(){

                @Override
                public Class<?> getType() {
                    return DecodedObject.this.type;
                }

                public void onMessage(Object message) {
                    Object result = AnnotatedEndpoint.this.callMethod(DecodedObject.this.method, DecodedObject.this.extractors, session, new Object[]{message});
                    if (result != null) {
                        try {
                            session.getRemote().sendObject(result);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error trying to send the response.", e);
                        }
                    }
                }
            };
        }
    }

    class CharacterStream
    extends MessageHandlerFactory {
        CharacterStream(Method method, ParameterExtractor[] extractors) {
            super(method, extractors);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new MessageHandler.CharacterStream(){

                @Override
                public void onMessage(Reader message) {
                    Object result = AnnotatedEndpoint.this.callMethod(CharacterStream.this.method, CharacterStream.this.extractors, session, new Object[]{message});
                    if (result != null) {
                        try {
                            session.getRemote().sendObject(result);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error trying to send the response.", e);
                        }
                    }
                }
            };
        }
    }

    class BinaryStream
    extends MessageHandlerFactory {
        BinaryStream(Method method, ParameterExtractor[] extractors) {
            super(method, extractors);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new MessageHandler.BinaryStream(){

                @Override
                public void onMessage(InputStream message) {
                    Object result = AnnotatedEndpoint.this.callMethod(BinaryStream.this.method, BinaryStream.this.extractors, session, new Object[]{message});
                    if (result != null) {
                        try {
                            session.getRemote().sendObject(result);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error trying to send the response.", e);
                        }
                    }
                }
            };
        }
    }

    class Text
    extends MessageHandlerFactory {
        Text(Method method, ParameterExtractor[] extractors) {
            super(method, extractors);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new MessageHandler.Text(){

                @Override
                public void onMessage(String message) {
                    Object result = AnnotatedEndpoint.this.callMethod(Text.this.method, Text.this.extractors, session, new Object[]{message});
                    if (result != null) {
                        try {
                            session.getRemote().sendObject(result);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error trying to send the response.", e);
                        }
                    }
                }
            };
        }
    }

    class Binary
    extends MessageHandlerFactory {
        Binary(Method method, ParameterExtractor[] extractors) {
            super(method, extractors);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new MessageHandler.Binary(){

                @Override
                public void onMessage(ByteBuffer message) {
                    Object result = AnnotatedEndpoint.this.callMethod(Binary.this.method, Binary.this.extractors, session, new Object[]{message});
                    if (result != null) {
                        try {
                            session.getRemote().sendObject(result);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error trying to send the response.", e);
                        }
                    }
                }
            };
        }
    }

    class AsyncBinary
    extends MessageHandlerFactory {
        AsyncBinary(Method method, ParameterExtractor[] extractors) {
            super(method, extractors);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new MessageHandler.AsyncBinary(){

                @Override
                public void onMessagePart(ByteBuffer part, boolean last) {
                    AnnotatedEndpoint.this.callMethod(AsyncBinary.this.method, AsyncBinary.this.extractors, session, new Object[]{part, last});
                }
            };
        }
    }

    class AsyncText
    extends MessageHandlerFactory {
        AsyncText(Method method, ParameterExtractor[] extractors) {
            super(method, extractors);
        }

        @Override
        public MessageHandler create(final Session session) {
            return new MessageHandler.AsyncText(){

                @Override
                public void onMessagePart(String part, boolean last) {
                    AnnotatedEndpoint.this.callMethod(AsyncText.this.method, AsyncText.this.extractors, session, new Object[]{part, last});
                }
            };
        }
    }

    abstract class MessageHandlerFactory {
        final Method method;
        final ParameterExtractor[] extractors;

        MessageHandlerFactory(Method method, ParameterExtractor[] extractors) {
            this.method = method;
            this.extractors = extractors;
        }

        abstract MessageHandler create(Session var1);
    }

    static class ParamValue
    implements ParameterExtractor {
        private final int index;

        ParamValue(int index) {
            this.index = index;
        }

        @Override
        public Object value(Session session, Object ... paramValues) {
            return paramValues[this.index];
        }
    }

    static interface ParameterExtractor {
        public Object value(Session var1, Object ... var2);
    }
}

