/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.net.websocket.MessageHandler;
import org.glassfish.tyrus.BufferedBinaryDataSource;
import org.glassfish.tyrus.BufferedBinaryDataSourceReader;

class AsyncBinaryToOutputStreamAdapter
implements BufferedBinaryDataSource,
MessageHandler.AsyncBinary {
    private static final long MAX_BUFFER_SIZE = 8192L;
    private List<ByteBuffer> bufferedFragments = new ArrayList<ByteBuffer>();
    private boolean receivedLast = false;
    private BufferedBinaryDataSourceReader reader = null;
    private MessageHandler.BinaryStream mh;
    private final Object stateLock;

    public AsyncBinaryToOutputStreamAdapter(MessageHandler.BinaryStream mh) {
        this.mh = mh;
        this.stateLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockOnReaderThread() {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                this.stateLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte[] getNextBytes(int numberOfBytes) {
        if (this.bufferedFragments.isEmpty()) {
            if (this.receivedLast) {
                this.reader = null;
                return null;
            }
            this.blockOnReaderThread();
        }
        byte[] bytes = new byte[1];
        ByteBuffer nextFragment = this.bufferedFragments.get(0);
        bytes[0] = nextFragment.array()[0];
        this.bufferedFragments.remove(0);
        if (nextFragment.array().length > 1) {
            byte[] newBytes = new byte[nextFragment.array().length - 1];
            System.arraycopy(nextFragment.array(), 1, newBytes, 0, nextFragment.array().length - 1);
            this.bufferedFragments.add(0, ByteBuffer.wrap(newBytes));
        }
        return bytes;
    }

    @Override
    public void finishedReading() {
        this.bufferedFragments = new ArrayList<ByteBuffer>();
        this.reader = null;
    }

    private void checkForBufferOverflow(ByteBuffer part) {
        int numberOfBytes = 0;
        for (ByteBuffer fragment : this.bufferedFragments) {
            numberOfBytes += fragment.limit();
        }
        if (8192L < (long)(numberOfBytes + part.limit())) {
            throw new IllegalStateException("Buffer overflow");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessagePart(ByteBuffer part, boolean last) {
        this.receivedLast = last;
        this.checkForBufferOverflow(part);
        this.bufferedFragments.add(part);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
        if (this.reader == null) {
            this.reader = new BufferedBinaryDataSourceReader(this);
            Thread t = new Thread(){

                @Override
                public void run() {
                    AsyncBinaryToOutputStreamAdapter.this.mh.onMessage(AsyncBinaryToOutputStreamAdapter.this.reader);
                }
            };
            t.start();
        }
    }
}

