/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.util.ArrayList;
import java.util.List;
import javax.net.websocket.MessageHandler;
import org.glassfish.tyrus.BufferedStringSource;
import org.glassfish.tyrus.BufferedStringSourceReader;

class AsyncTextToCharStreamAdapter
implements BufferedStringSource,
MessageHandler.AsyncText {
    private static final long MAX_BUFFER_SIZE = 8192L;
    private List<String> bufferedFragments = new ArrayList<String>();
    private boolean receivedLast = false;
    private BufferedStringSourceReader reader = null;
    private MessageHandler.CharacterStream mh;
    private final Object stateLock;

    public AsyncTextToCharStreamAdapter(MessageHandler.CharacterStream mh) {
        this.mh = mh;
        this.stateLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockOnReaderThread() {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                this.stateLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public char[] getNextChars(int numberOfChars) {
        if (this.bufferedFragments.isEmpty()) {
            if (this.receivedLast) {
                this.reader = null;
                return null;
            }
            this.blockOnReaderThread();
        }
        char[] chrs = new char[1];
        String nextFragment = this.bufferedFragments.get(0);
        chrs[0] = nextFragment.charAt(0);
        this.bufferedFragments.remove(0);
        if (nextFragment.length() > 1) {
            String newFragment = nextFragment.substring(1, nextFragment.length());
            this.bufferedFragments.add(0, newFragment);
        }
        return chrs;
    }

    @Override
    public void finishedReading() {
        this.bufferedFragments = new ArrayList<String>();
        this.reader = null;
    }

    private void checkForBufferOverflow(String part) {
        int numberOfBytes = 0;
        for (String fragment : this.bufferedFragments) {
            numberOfBytes += fragment.length();
        }
        if (8192L < (long)(numberOfBytes + part.length())) {
            throw new IllegalStateException("Buffer overflow");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessagePart(String part, boolean last) {
        this.receivedLast = last;
        this.checkForBufferOverflow(part);
        this.bufferedFragments.add(part);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
        if (this.reader == null) {
            this.reader = new BufferedStringSourceReader(this);
            Thread t = new Thread(){

                @Override
                public void run() {
                    AsyncTextToCharStreamAdapter.this.mh.onMessage(AsyncTextToCharStreamAdapter.this.reader);
                }
            };
            t.start();
        }
    }
}

