/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.util.Collections;
import java.util.List;
import javax.net.websocket.Decoder;
import javax.net.websocket.Encoder;
import javax.net.websocket.EndpointConfiguration;

public abstract class DefaultEndpointConfiguration
implements EndpointConfiguration {
    private final List<Encoder> encoders;
    private final List<Decoder> decoders;
    protected final List<String> subProtocols;
    protected final List<String> extensions;
    protected final String uri;

    protected DefaultEndpointConfiguration(String uri, List<Encoder> encoders, List<Decoder> decoders, List<String> subprotocols, List<String> extensions) {
        List emptyList;
        this.uri = uri;
        if (encoders != null) {
            this.encoders = Collections.unmodifiableList(encoders);
        } else {
            emptyList = Collections.emptyList();
            this.encoders = Collections.unmodifiableList(emptyList);
        }
        if (decoders != null) {
            this.decoders = Collections.unmodifiableList(decoders);
        } else {
            emptyList = Collections.emptyList();
            this.decoders = Collections.unmodifiableList(emptyList);
        }
        this.subProtocols = subprotocols != null ? Collections.unmodifiableList(subprotocols) : Collections.emptyList();
        this.extensions = extensions != null ? Collections.unmodifiableList(extensions) : Collections.emptyList();
    }

    @Override
    public List<Encoder> getEncoders() {
        return this.encoders;
    }

    @Override
    public List<Decoder> getDecoders() {
        return this.decoders;
    }

    @Override
    public String getPath() {
        return this.uri;
    }

    protected static class Builder<T extends Builder> {
        protected String uri;
        protected List<Encoder> encoders;
        protected List<Decoder> decoders;
        protected List<String> protocols;
        protected List<String> extensions;

        public Builder(String uri) {
            this.uri = uri;
        }

        public final T encoders(List<Encoder> encoders) {
            this.encoders = encoders;
            return (T)this;
        }

        public final T decoders(List<Decoder> decoders) {
            this.decoders = decoders;
            return (T)this;
        }

        public T protocols(List<String> protocols) {
            this.protocols = protocols;
            return (T)this;
        }

        public T extensions(List<String> extensions) {
            this.extensions = extensions;
            return (T)this;
        }
    }
}

