/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.websocket.ClientContainer;
import javax.net.websocket.DecodeException;
import javax.net.websocket.Decoder;
import javax.net.websocket.EncodeException;
import javax.net.websocket.Encoder;
import javax.net.websocket.Endpoint;
import javax.net.websocket.EndpointConfiguration;
import javax.net.websocket.MessageHandler;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.ServerEndpointConfiguration;
import org.glassfish.tyrus.DecoderWrapper;
import org.glassfish.tyrus.NoOpBinaryCoder;
import org.glassfish.tyrus.NoOpTextCoder;
import org.glassfish.tyrus.PrimitiveDecoders;
import org.glassfish.tyrus.ReflectionHelper;
import org.glassfish.tyrus.SessionImpl;
import org.glassfish.tyrus.ToStringEncoder;
import org.glassfish.tyrus.internal.PathPattern;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;

public class EndpointWrapper
extends SPIEndpoint {
    private final ClientContainer container;
    private final String contextPath;
    private final List<Decoder> decoders = new ArrayList<Decoder>();
    private final List<Encoder> encoders = new ArrayList<Encoder>();
    private final EndpointConfiguration configuration;
    private final Endpoint endpoint;
    private final Map<RemoteEndpoint, SessionImpl> remoteEndpointToSession = new ConcurrentHashMap<RemoteEndpoint, SessionImpl>();
    private String uri;
    private final Map<String, String> templateValues = new HashMap<String, String>();
    private boolean isSecure;
    private String queryString;

    public EndpointWrapper(Endpoint endpoint, EndpointConfiguration configuration, ClientContainer container, String contextPath) {
        this.endpoint = endpoint;
        this.configuration = configuration;
        this.container = container;
        this.contextPath = contextPath;
        this.decoders.addAll(configuration.getDecoders());
        this.decoders.addAll(PrimitiveDecoders.ALL);
        this.decoders.add(NoOpTextCoder.INSTANCE);
        this.decoders.add(NoOpBinaryCoder.INSTANCE);
        this.encoders.addAll(configuration.getEncoders());
        this.encoders.add(NoOpTextCoder.INSTANCE);
        this.encoders.add(NoOpBinaryCoder.INSTANCE);
        this.encoders.add(ToStringEncoder.INSTANCE);
    }

    @Override
    public boolean checkHandshake(SPIHandshakeRequest hr) {
        if (!(this.configuration instanceof ServerEndpointConfiguration)) {
            return false;
        }
        ServerEndpointConfiguration sec = (ServerEndpointConfiguration)this.configuration;
        this.uri = hr.getRequestUri();
        this.queryString = hr.getQueryString();
        this.isSecure = hr.isSecure();
        PathPattern pathPattern = new PathPattern(this.getEndpointPath(sec.getPath()));
        boolean match = pathPattern.match(this.uri, pathPattern.getTemplate().getTemplateVariables(), this.templateValues);
        return match && sec.checkOrigin(hr.getHeader("Origin"));
    }

    private String getEndpointPath(String relativePath) {
        return (this.contextPath.endsWith("/") ? this.contextPath.substring(0, this.contextPath.length() - 1) : this.contextPath) + "/" + (relativePath.startsWith("/") ? relativePath.substring(1) : relativePath);
    }

    public Object decodeCompleteMessage(Object message, Class<?> type, boolean isString) {
        for (Decoder dec : this.decoders) {
            try {
                Method m;
                if (isString && dec instanceof Decoder.Text) {
                    m = dec.getClass().getDeclaredMethod("decode", String.class);
                    if (type == null || !type.isAssignableFrom(m.getReturnType()) || !((Decoder.Text)dec).willDecode((String)message)) continue;
                    return ((Decoder.Text)dec).decode((String)message);
                }
                if (!isString && dec instanceof Decoder.Binary) {
                    m = dec.getClass().getDeclaredMethod("decode", ByteBuffer.class);
                    if (type == null || !type.isAssignableFrom(m.getReturnType()) || !((Decoder.Binary)dec).willDecode((ByteBuffer)message)) continue;
                    return ((Decoder.Binary)dec).decode((ByteBuffer)message);
                }
                if (isString && dec instanceof Decoder.TextStream) {
                    m = dec.getClass().getDeclaredMethod("decode", Reader.class);
                    if (type == null || !type.isAssignableFrom(m.getReturnType())) continue;
                    return ((Decoder.TextStream)dec).decode(new StringReader((String)message));
                }
                if (isString || !(dec instanceof Decoder.BinaryStream)) continue;
                m = dec.getClass().getDeclaredMethod("decode", InputStream.class);
                if (type == null || !type.isAssignableFrom(m.getReturnType())) continue;
                byte[] array = ((ByteBuffer)message).array();
                return ((Decoder.BinaryStream)dec).decode(new ByteArrayInputStream(array));
            }
            catch (DecodeException de) {
                de.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private ArrayList<DecoderWrapper> findApplicableDecoders(Object message, boolean isString) {
        ArrayList<DecoderWrapper> result = new ArrayList<DecoderWrapper>();
        for (Decoder dec : this.decoders) {
            Class<?> type;
            if (isString && dec instanceof Decoder.Text) {
                if (!((Decoder.Text)dec).willDecode((String)message)) continue;
                type = this.getClassType(dec.getClass(), Decoder.Text.class);
                result.add(new DecoderWrapper(dec, type, Decoder.Text.class));
                continue;
            }
            if (!isString && dec instanceof Decoder.Binary) {
                if (!((Decoder.Binary)dec).willDecode((ByteBuffer)message)) continue;
                type = this.getClassType(dec.getClass(), Decoder.Binary.class);
                result.add(new DecoderWrapper(dec, type, Decoder.Binary.class));
                continue;
            }
            if (isString && dec instanceof Decoder.TextStream) {
                type = this.getClassType(dec.getClass(), Decoder.TextStream.class);
                result.add(new DecoderWrapper(dec, type, Decoder.TextStream.class));
                continue;
            }
            if (isString || !(dec instanceof Decoder.BinaryStream)) continue;
            type = this.getClassType(dec.getClass(), Decoder.BinaryStream.class);
            result.add(new DecoderWrapper(dec, type, Decoder.BinaryStream.class));
        }
        return result;
    }

    private Class<?> getClassType(Class<?> inspectedClass, Class<?> rootClass) {
        ReflectionHelper.DeclaringClassInterfacePair p = ReflectionHelper.getClass(inspectedClass, rootClass);
        Class[] as = ReflectionHelper.getParameterizedClassArguments(p);
        if (as == null) {
            return null;
        }
        return as[0];
    }

    Object doEncode(Object message) throws EncodeException {
        for (Encoder enc : this.encoders) {
            try {
                Class type;
                Class[] as;
                ReflectionHelper.DeclaringClassInterfacePair p;
                if (enc instanceof Encoder.Binary) {
                    p = ReflectionHelper.getClass(enc.getClass(), Encoder.Binary.class);
                    as = ReflectionHelper.getParameterizedClassArguments(p);
                    type = as[0];
                    if (!message.getClass().isAssignableFrom(type)) continue;
                    return ((Encoder.Binary)enc).encode(message);
                }
                if (enc instanceof Encoder.Text) {
                    p = ReflectionHelper.getClass(enc.getClass(), Encoder.Text.class);
                    as = ReflectionHelper.getParameterizedClassArguments(p);
                    type = as[0];
                    if (!message.getClass().isAssignableFrom(type)) continue;
                    return ((Encoder.Text)enc).encode(message);
                }
                if (enc instanceof Encoder.BinaryStream) {
                    p = ReflectionHelper.getClass(enc.getClass(), Encoder.BinaryStream.class);
                    as = ReflectionHelper.getParameterizedClassArguments(p);
                    type = as[0];
                    if (!message.getClass().isAssignableFrom(type)) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ((Encoder.BinaryStream)enc).encode(message, new ByteArrayOutputStream());
                    return baos;
                }
                if (!(enc instanceof Encoder.TextStream)) continue;
                p = ReflectionHelper.getClass(enc.getClass(), Encoder.TextStream.class);
                as = ReflectionHelper.getParameterizedClassArguments(p);
                type = as[0];
                if (!message.getClass().isAssignableFrom(type)) continue;
                StringWriter writer = new StringWriter();
                ((Encoder.TextStream)enc).encode(message, writer);
                return writer;
            }
            catch (EncodeException ee) {
                ee.printStackTrace();
                throw ee;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new EncodeException("Unable to encode ", message);
    }

    @Override
    public List<String> getNegotiatedExtensions(List<String> clientExtensions) {
        if (!(this.configuration instanceof ServerEndpointConfiguration)) {
            return null;
        }
        ServerEndpointConfiguration sec = (ServerEndpointConfiguration)this.configuration;
        return sec.getNegotiatedExtensions(clientExtensions);
    }

    @Override
    public String getNegotiatedProtocol(List<String> clientProtocols) {
        if (!(this.configuration instanceof ServerEndpointConfiguration)) {
            return null;
        }
        ServerEndpointConfiguration sec = (ServerEndpointConfiguration)this.configuration;
        return sec.getNegotiatedSubprotocol(clientProtocols);
    }

    @Override
    public void remove() {
    }

    @Override
    public void onConnect(RemoteEndpoint gs, String subprotocol, List<String> extensions) {
        SessionImpl session = new SessionImpl(this.container, gs, this, subprotocol, extensions, this.isSecure, this.uri == null ? null : URI.create(this.uri), this.queryString, this.templateValues);
        this.remoteEndpointToSession.put(gs, session);
        this.endpoint.onOpen(session);
    }

    @Override
    public void onMessage(RemoteEndpoint gs, ByteBuffer messageBytes) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.notifyMessageHandlers(messageBytes, this.findApplicableDecoders(messageBytes, false));
    }

    @Override
    public void onMessage(RemoteEndpoint gs, String messageString) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.notifyMessageHandlers(messageString, this.findApplicableDecoders(messageString, true));
    }

    @Override
    public void onPartialMessage(RemoteEndpoint gs, String partialString, boolean last) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.notifyMessageHandlers(partialString, last);
    }

    @Override
    public void onPartialMessage(RemoteEndpoint gs, ByteBuffer partialBytes, boolean last) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.notifyMessageHandlers(partialBytes, last);
    }

    @Override
    public void onPong(RemoteEndpoint gs, ByteBuffer bytes) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        boolean handled = false;
        for (MessageHandler handler : session.getMessageHandlers()) {
            if (!(handler instanceof MessageHandler.Pong)) continue;
            ((MessageHandler.Pong)handler).onPong(bytes);
            handled = true;
        }
        if (!handled) {
            System.out.println("Unhandled pong message in EndpointWrapper");
        }
    }

    @Override
    public void onPing(RemoteEndpoint gs, ByteBuffer bytes) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        session.getRemote().sendPong(bytes);
    }

    @Override
    public void onClose(RemoteEndpoint gs) {
        SessionImpl session = this.remoteEndpointToSession.get(gs);
        this.endpoint.onClose(session, null);
        this.remoteEndpointToSession.remove(gs);
    }

    boolean isActive(SessionImpl session) {
        return this.remoteEndpointToSession.values().contains(session);
    }
}

