/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.net.websocket.CloseReason;
import javax.net.websocket.EncodeException;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.SendHandler;
import javax.net.websocket.SendResult;
import javax.net.websocket.Session;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.OutputStreamToAsyncBinaryAdapter;
import org.glassfish.tyrus.SendCompletionAdapter;
import org.glassfish.tyrus.SessionImpl;
import org.glassfish.tyrus.WriterToAsyncTextAdapter;

public final class RemoteEndpointWrapper<T>
implements RemoteEndpoint<T> {
    private final RemoteEndpoint remoteEndpoint;
    private final SessionImpl session;
    private final EndpointWrapper endpointWrapper;

    RemoteEndpointWrapper(SessionImpl session, RemoteEndpoint remoteEndpoint, EndpointWrapper endpointWrapper) {
        this.remoteEndpoint = remoteEndpoint;
        this.endpointWrapper = endpointWrapper;
        this.session = session;
    }

    @Override
    public void sendString(String data) throws IOException {
        this.remoteEndpoint.sendString(data);
        this.session.updateLastConnectionActivity();
    }

    @Override
    public void sendBytes(ByteBuffer data) throws IOException {
        this.remoteEndpoint.sendBytes(data);
        this.session.updateLastConnectionActivity();
    }

    @Override
    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        this.remoteEndpoint.sendPartialString(fragment, isLast);
        this.session.updateLastConnectionActivity();
    }

    @Override
    public void sendPartialBytes(ByteBuffer byteBuffer, boolean isLast) throws IOException {
        this.remoteEndpoint.sendPartialBytes(byteBuffer, isLast);
        this.session.updateLastConnectionActivity();
    }

    @Override
    public OutputStream getSendStream() throws IOException {
        return new OutputStreamToAsyncBinaryAdapter(this);
    }

    @Override
    public Writer getSendWriter() throws IOException {
        return new WriterToAsyncTextAdapter(this);
    }

    @Override
    public void sendObject(T o) throws IOException, EncodeException {
        this.session.updateLastConnectionActivity();
        this.sendPolymorphic(o);
    }

    @Override
    public Future<SendResult> sendString(String text, SendHandler completion) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.TEXT);
        Future<SendResult> fsr = goesAway.send(text, completion);
        this.session.updateLastConnectionActivity();
        return fsr;
    }

    @Override
    public Future<SendResult> sendBytes(ByteBuffer data, SendHandler completion) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.BINARY);
        Future<SendResult> fsr = goesAway.send(data, completion);
        this.session.updateLastConnectionActivity();
        return fsr;
    }

    @Override
    public Future<SendResult> sendObject(T o, SendHandler completion) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.OBJECT);
        Future<SendResult> fsr = goesAway.send(o, completion);
        this.session.updateLastConnectionActivity();
        return fsr;
    }

    @Override
    public void sendPing(ByteBuffer applicationData) {
        this.remoteEndpoint.sendPing(applicationData);
        this.session.updateLastConnectionActivity();
    }

    @Override
    public void sendPong(ByteBuffer applicationData) {
        this.remoteEndpoint.sendPong(applicationData);
        this.session.updateLastConnectionActivity();
    }

    public String toString() {
        return "Wrapped: " + this.getClass().getSimpleName();
    }

    private void sendPrimitiveMessage(Object data) throws IOException, EncodeException {
        if (!this.isPrimitiveData(data)) {
            throw new EncodeException("object " + data + " is not a primitive type.", data);
        }
        this.sendString(data.toString());
    }

    private void sendPolymorphic(Object o) throws IOException, EncodeException {
        if (o instanceof String) {
            this.sendString((String)o);
        } else if (this.isPrimitiveData(o)) {
            this.sendPrimitiveMessage(o);
        } else {
            Object toSend = this.endpointWrapper.doEncode(o);
            if (toSend instanceof String) {
                this.sendString((String)toSend);
            } else if (toSend instanceof ByteBuffer) {
                this.sendBytes((ByteBuffer)toSend);
            } else if (toSend instanceof StringWriter) {
                StringWriter writer = (StringWriter)toSend;
                StringBuffer sb = writer.getBuffer();
                this.sendString(sb.toString());
            } else if (toSend instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
                ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
                this.sendBytes(buffer);
            }
        }
    }

    private boolean isPrimitiveData(Object data) {
        Class<?> dataClass = data.getClass();
        return dataClass.equals(Integer.class) || dataClass.equals(Byte.class) || dataClass.equals(Short.class) || dataClass.equals(Long.class) || dataClass.equals(Float.class) || dataClass.equals(Double.class) || dataClass.equals(Boolean.class) || dataClass.equals(Character.class);
    }

    public void close(CloseReason cr) throws IOException {
        System.out.println("Close  public void close(CloseReason cr): " + cr);
    }

    public Session getSession() {
        return this.session;
    }

    public void updateLastConnectionActivity() {
        this.session.updateLastConnectionActivity();
    }
}

