/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.websocket.ClientContainer;
import javax.net.websocket.CloseReason;
import javax.net.websocket.Encoder;
import javax.net.websocket.MessageHandler;
import javax.net.websocket.RemoteEndpoint;
import javax.net.websocket.Session;
import org.glassfish.tyrus.AsyncBinaryToOutputStreamAdapter;
import org.glassfish.tyrus.AsyncTextToCharStreamAdapter;
import org.glassfish.tyrus.DecodedObjectMessageHandler;
import org.glassfish.tyrus.DecoderWrapper;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.ReflectionHelper;
import org.glassfish.tyrus.RemoteEndpointWrapper;

public class SessionImpl<T>
implements Session<T> {
    private final ClientContainer container;
    private final EndpointWrapper endpoint;
    private final RemoteEndpointWrapper remote;
    private final String negotiatedSubprotocol;
    private final List<String> negotiatedExtensions;
    private final boolean isSecure;
    private final URI uri;
    private final String queryString;
    private final Map<String, String> pathParameters;
    private Map<MessageHandler, MessageHandler> messageHandlerToInvokableMessageHandlers = new HashMap<MessageHandler, MessageHandler>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private long timeout;
    private long maximumMessageSize = 8192L;
    private long lastConnectionActivity;

    SessionImpl(ClientContainer container, RemoteEndpoint remoteEndpoint, EndpointWrapper endpointWrapper, String subprotocol, List<String> extensions, boolean isSecure, URI uri, String queryString, Map<String, String> pathParameters) {
        this.container = container;
        this.endpoint = endpointWrapper;
        this.negotiatedSubprotocol = subprotocol;
        this.negotiatedExtensions = extensions == null ? Collections.emptyList() : Collections.unmodifiableList(extensions);
        this.isSecure = isSecure;
        this.uri = uri;
        this.queryString = queryString;
        this.pathParameters = Collections.unmodifiableMap(pathParameters);
        this.remote = new RemoteEndpointWrapper(this, remoteEndpoint, endpointWrapper);
    }

    @Override
    public String getProtocolVersion() {
        return "13";
    }

    @Override
    public String getNegotiatedSubprotocol() {
        return this.negotiatedSubprotocol;
    }

    @Override
    public RemoteEndpoint getRemote() {
        return this.remote;
    }

    @Override
    public RemoteEndpoint<T> getRemoteL(Class<T> aClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isActive() {
        return this.endpoint.isActive(this);
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void close() throws IOException {
        this.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, "no reason given"));
    }

    @Override
    public void close(CloseReason closeReason) throws IOException {
        this.remote.close(closeReason);
    }

    public String toString() {
        return "Session(" + this.hashCode() + ", " + this.isActive() + ")";
    }

    @Override
    public void setTimeout(long seconds) {
        this.timeout = seconds;
    }

    @Override
    public void setMaximumMessageSize(long maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    @Override
    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @Override
    public List<String> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public long getInactiveTime() {
        return (System.currentTimeMillis() - this.lastConnectionActivity) / 1000L;
    }

    @Override
    public ClientContainer getContainer() {
        return this.container;
    }

    @Override
    public void setEncoders(List<Encoder> encoders) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMessageHandler(MessageHandler listener) {
        MessageHandler invokable = listener instanceof MessageHandler.CharacterStream ? new AsyncTextToCharStreamAdapter((MessageHandler.CharacterStream)listener) : (listener instanceof MessageHandler.BinaryStream ? new AsyncBinaryToOutputStreamAdapter((MessageHandler.BinaryStream)listener) : listener);
        this.messageHandlerToInvokableMessageHandlers.put(listener, invokable);
    }

    @Override
    public Set<MessageHandler> getMessageHandlers() {
        return Collections.unmodifiableSet(this.messageHandlerToInvokableMessageHandlers.keySet());
    }

    @Override
    public void removeMessageHandler(MessageHandler listener) {
        this.messageHandlerToInvokableMessageHandlers.remove(listener);
    }

    @Override
    public URI getRequestURI() {
        return this.uri;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return Collections.emptyMap();
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    void updateLastConnectionActivity() {
        this.lastConnectionActivity = System.currentTimeMillis();
    }

    void notifyMessageHandlers(String message, List<DecoderWrapper> availableDecoders) {
        this.updateLastConnectionActivity();
        boolean decoded = false;
        if (availableDecoders.isEmpty()) {
            System.out.println("No Decoder found");
        }
        try {
            for (DecoderWrapper decoder : availableDecoders) {
                for (MessageHandler mh : this.getOrderedMessageHandlers()) {
                    Object object;
                    Class<MessageHandler.DecodedObject> type;
                    if (mh instanceof MessageHandler.Text) {
                        ((MessageHandler.Text)mh).onMessage(message);
                        decoded = true;
                        break;
                    }
                    if (mh instanceof DecodedObjectMessageHandler) {
                        Object object2;
                        DecodedObjectMessageHandler domh = (DecodedObjectMessageHandler)mh;
                        Class<?> type2 = domh.getType();
                        if (type2 == null || !type2.isAssignableFrom(decoder.getType()) || (object2 = this.endpoint.decodeCompleteMessage(message, domh.getType(), true)) == null) continue;
                        domh.onMessage(object2);
                        decoded = true;
                        break;
                    }
                    if (!(mh instanceof MessageHandler.DecodedObject) || (type = this.getClassType(mh.getClass(), MessageHandler.DecodedObject.class)) == null || !type.isAssignableFrom(decoder.getType()) || (object = this.endpoint.decodeCompleteMessage(message, type, true)) == null) continue;
                    ((MessageHandler.DecodedObject)mh).onMessage(object);
                    decoded = true;
                    break;
                }
                if (!decoded) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void notifyMessageHandlers(ByteBuffer message, List<DecoderWrapper> availableDecoders) {
        this.updateLastConnectionActivity();
        boolean decoded = false;
        if (availableDecoders.isEmpty()) {
            System.out.println("No Decoder found");
        }
        try {
            for (DecoderWrapper decoder : availableDecoders) {
                for (MessageHandler mh : this.getOrderedMessageHandlers()) {
                    Object object;
                    Class<MessageHandler.DecodedObject> type;
                    if (mh instanceof MessageHandler.Binary) {
                        ((MessageHandler.Binary)mh).onMessage(message);
                        decoded = true;
                        break;
                    }
                    if (mh instanceof DecodedObjectMessageHandler) {
                        Object object2;
                        DecodedObjectMessageHandler domh = (DecodedObjectMessageHandler)mh;
                        Class<?> type2 = domh.getType();
                        if (type2 == null || !type2.isAssignableFrom(decoder.getType()) || (object2 = this.endpoint.decodeCompleteMessage(message, domh.getType(), true)) == null) continue;
                        domh.onMessage(object2);
                        decoded = true;
                        break;
                    }
                    if (!(mh instanceof MessageHandler.DecodedObject) || (type = this.getClassType(mh.getClass(), MessageHandler.DecodedObject.class)) == null || !type.isAssignableFrom(decoder.getType()) || (object = this.endpoint.decodeCompleteMessage(message, type, true)) == null) continue;
                    ((MessageHandler.DecodedObject)mh).onMessage(object);
                    decoded = true;
                    break;
                }
                if (!decoded) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void notifyMessageHandlers(ByteBuffer partialBytes, boolean last) {
        boolean handled = false;
        for (MessageHandler handler : this.getInvokableMessageHandlers()) {
            if (!(handler instanceof MessageHandler.AsyncBinary)) continue;
            ((MessageHandler.AsyncBinary)handler).onMessagePart(partialBytes, last);
            handled = true;
            break;
        }
        if (!handled) {
            System.out.println("Unhandled partial binary message in EndpointWrapper");
        }
    }

    void notifyMessageHandlers(String partialString, boolean last) {
        boolean handled = false;
        for (MessageHandler handler : this.getInvokableMessageHandlers()) {
            if (!(handler instanceof MessageHandler.AsyncText)) continue;
            MessageHandler.AsyncText baseHandler = (MessageHandler.AsyncText)handler;
            baseHandler.onMessagePart(partialString, last);
            handled = true;
            break;
        }
        if (!handled) {
            System.out.println("Unhandled text message in EndpointWrapper");
        }
    }

    private Class<?> getClassType(Class<?> inspectedClass, Class<?> rootClass) {
        ReflectionHelper.DeclaringClassInterfacePair p = ReflectionHelper.getClass(inspectedClass, rootClass);
        Class[] as = ReflectionHelper.getParameterizedClassArguments(p);
        if (as == null) {
            return null;
        }
        return as[0];
    }

    Set<MessageHandler> getInvokableMessageHandlers() {
        HashSet<MessageHandler> s = new HashSet<MessageHandler>();
        for (MessageHandler mh : this.messageHandlerToInvokableMessageHandlers.values()) {
            s.add(mh);
        }
        return s;
    }

    private List<MessageHandler> getOrderedMessageHandlers() {
        Set<MessageHandler> handlers = this.getMessageHandlers();
        ArrayList<MessageHandler> result = new ArrayList<MessageHandler>();
        result.addAll(handlers);
        Collections.sort(result, new MessageHandlerComparator());
        return result;
    }

    private class MessageHandlerComparator
    implements Comparator<MessageHandler> {
        private MessageHandlerComparator() {
        }

        @Override
        public int compare(MessageHandler o1, MessageHandler o2) {
            if (o1 instanceof MessageHandler.DecodedObject) {
                if (o2 instanceof MessageHandler.DecodedObject) {
                    Class type2;
                    Class type1 = SessionImpl.this.getClassType(o1.getClass(), MessageHandler.DecodedObject.class);
                    if (type1.isAssignableFrom(type2 = SessionImpl.this.getClassType(o2.getClass(), MessageHandler.DecodedObject.class))) {
                        return 1;
                    }
                    if (type2.isAssignableFrom(type1)) {
                        return -1;
                    }
                    return 0;
                }
                return 1;
            }
            if (o2 instanceof MessageHandler.DecodedObject) {
                return 1;
            }
            return 0;
        }
    }
}

