/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.websocket.ClientContainer;
import javax.net.websocket.ClientEndpointConfiguration;
import javax.net.websocket.Endpoint;
import javax.net.websocket.Session;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.spi.TyrusClientSocket;
import org.glassfish.tyrus.spi.TyrusContainer;

public class ClientManager
implements ClientContainer {
    private static final String ENGINE_PROVIDER_CLASSNAME = "org.glassfish.tyrus.grizzly.GrizzlyEngine";
    private final Set<TyrusClientSocket> sockets = new HashSet<TyrusClientSocket>();
    private final TyrusContainer engine;

    public static ClientManager createClient() {
        return ClientManager.createClient(ENGINE_PROVIDER_CLASSNAME);
    }

    public static ClientManager createClient(String engineProviderClassname) {
        try {
            Class<?> engineProviderClazz = Class.forName(engineProviderClassname);
            Logger.getLogger(ClientManager.class.getName()).info("Provider class loaded: " + engineProviderClassname);
            return new ClientManager((TyrusContainer)engineProviderClazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load provider class: " + engineProviderClassname + ".");
        }
    }

    private ClientManager(TyrusContainer engine) {
        this.engine = engine;
    }

    @Override
    public void connectToServer(Endpoint endpoint, ClientEndpointConfiguration configuration) {
        try {
            EndpointWrapper clientEndpoint = new EndpointWrapper(endpoint, configuration, this, null);
            TyrusClientSocket clientSocket = this.engine.openClientSocket(configuration.getPath(), configuration, clientEndpoint);
            this.sockets.add(clientSocket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Set<Session> getActiveSessions() {
        return null;
    }

    @Override
    public long getMaxSessionIdleTimeout() {
        return 0L;
    }

    @Override
    public void setMaxSessionIdleTimeout(long timeout) {
    }

    @Override
    public long getMaxBinaryMessageBufferSize() {
        return 0L;
    }

    @Override
    public void setMaxBinaryMessageBufferSize(long max) {
    }

    @Override
    public long getMaxTextMessageBufferSize() {
        return 0L;
    }

    @Override
    public void setMaxTextMessageBufferSize(long max) {
    }

    @Override
    public Set<String> getInstalledExtensions() {
        return null;
    }
}

