/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.oldservlet;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.websocket.annotations.WebSocketEndpoint;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.glassfish.tyrus.oldservlet.GrizzlyBasedEngine;
import org.glassfish.tyrus.server.ContainerConfig;
import org.glassfish.tyrus.server.DefaultServerConfiguration;
import org.glassfish.tyrus.server.ServerConfiguration;
import org.glassfish.tyrus.server.ServerContainer;
import org.glassfish.tyrus.server.ServerContainerFactory;

@WebListener
public class WebSocketServerWebIntegration
implements ServletContextListener {
    static final String ENDPOINT_CLASS_SET = "org.glassfish.websockets.platform.web.endpoint.class.set";
    private static final String DEFAULT_PROVIDER_CLASSNAME = GrizzlyBasedEngine.class.getName();
    private static final String PROVIDER_CLASSNAME_KEY = "org.glassfish.websocket.provider.class";
    public static final String PRINCIPAL = "ws_principal";
    private static final int INFORMATIONAL_FIXED_PORT = 8080;
    private ServerContainer serverContainer = null;

    public void contextInitialized(ServletContextEvent sce) {
        ServerConfiguration config;
        HashSet endpointClassSet;
        Set tmp = (Set)sce.getServletContext().getAttribute(ENDPOINT_CLASS_SET);
        HashSet hashSet = endpointClassSet = tmp == null ? Collections.emptySet() : new HashSet(tmp);
        if (endpointClassSet == null || endpointClassSet.isEmpty()) {
            return;
        }
        Class configClass = null;
        Iterator it = endpointClassSet.iterator();
        while (it.hasNext()) {
            Class cls = (Class)it.next();
            if (cls.getAnnotation(ContainerConfig.class) == null) continue;
            if (cls.getAnnotation(WebSocketEndpoint.class) == null) {
                it.remove();
            }
            if (!ServerConfiguration.class.isAssignableFrom(cls)) continue;
            if (configClass == null) {
                configClass = cls;
                continue;
            }
            Logger.getLogger(this.getClass().getName()).warning("Several server configuration classes found. " + cls.getName() + " will be ignored.");
        }
        if (configClass == null) {
            Logger.getLogger(this.getClass().getName()).info("No server configuration class found in the application. Using defaults.");
            config = new DefaultServerConfiguration().endpoints(endpointClassSet);
        } else {
            ServerConfiguration innerConfig;
            Logger.getLogger(this.getClass().getName()).info("Using " + configClass.getName() + " as the server configuration.");
            try {
                innerConfig = (ServerConfiguration)configClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate configuration class: " + configClass.getName(), e);
            }
            config = new ServerConfiguration(){
                private Set<Class<?>> cachedEndpointClasses;

                @Override
                public Set<Class<?>> getEndpointClasses() {
                    if (this.cachedEndpointClasses == null) {
                        this.cachedEndpointClasses = innerConfig.getEndpointClasses();
                        if (this.cachedEndpointClasses.isEmpty() && innerConfig.getEndpointInstances().isEmpty()) {
                            this.cachedEndpointClasses = Collections.unmodifiableSet(endpointClassSet);
                        }
                    }
                    return this.cachedEndpointClasses;
                }

                @Override
                public Set<ServerConfiguration.EndpointWithConfiguration> getEndpointInstances() {
                    return innerConfig.getEndpointInstances();
                }

                @Override
                public long getMaxSessionIdleTimeout() {
                    return innerConfig.getMaxSessionIdleTimeout();
                }

                @Override
                public long getMaxBinaryMessageBufferSize() {
                    return innerConfig.getMaxBinaryMessageBufferSize();
                }

                @Override
                public long getMaxTextMessageBufferSize() {
                    return innerConfig.getMaxTextMessageBufferSize();
                }

                @Override
                public List<String> getExtensions() {
                    return innerConfig.getExtensions();
                }
            };
        }
        String engineProviderClassname = DEFAULT_PROVIDER_CLASSNAME;
        if (sce.getServletContext().getInitParameter(PROVIDER_CLASSNAME_KEY) != null) {
            engineProviderClassname = sce.getServletContext().getInitParameter(PROVIDER_CLASSNAME_KEY);
        }
        String contextRoot = sce.getServletContext().getContextPath();
        this.serverContainer = ServerContainerFactory.create(engineProviderClassname, contextRoot, 8080, config);
        try {
            this.serverContainer.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Web socket server initialization failed.", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.serverContainer.stop();
    }
}

