/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.glassfish.tyrus.server.DefaultServerConfiguration;
import org.glassfish.tyrus.server.ServerConfiguration;
import org.glassfish.tyrus.server.ServerContainer;
import org.glassfish.tyrus.server.ServerContainerFactory;

public class Server {
    private ServerContainer server;
    private final ServerConfiguration configuration;
    private final String hostName;
    private final int port;
    private final String rootPath;
    private static final String ENGINE_PROVIDER_CLASSNAME = "org.glassfish.tyrus.grizzly.GrizzlyEngine";
    private static final Logger LOGGER = Logger.getLogger(Server.class.getClass().getName());
    private static final int DEFAULT_PORT = 8025;
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final String DEFAULT_ROOT_PATH = "/websockets/tests";

    public Server(Class<?> ... beans) {
        this(null, 0, null, beans);
    }

    public Server(String ... beanNames) {
        this(null, 0, null, new HashSet());
        for (String beanName : beanNames) {
            try {
                ((DefaultServerConfiguration)this.configuration).endpoint(Class.forName(beanName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Server(String hostName, int port, String rootPath, Class<?> ... beans) {
        this(hostName, port, rootPath, new HashSet(Arrays.asList(beans)));
    }

    public Server(String hostName, int port, String rootPath, Set<Class<?>> beans) {
        this(hostName, port, rootPath, new DefaultServerConfiguration().endpoints(beans));
    }

    public Server(String hostName, int port, String rootPath, ServerConfiguration configuration) {
        this.hostName = hostName == null ? DEFAULT_HOST_NAME : hostName;
        this.port = port == 0 ? 8025 : port;
        this.rootPath = rootPath == null ? DEFAULT_ROOT_PATH : rootPath;
        this.configuration = configuration;
    }

    public synchronized void start() {
        try {
            if (this.server == null) {
                this.server = ServerContainerFactory.create(ENGINE_PROVIDER_CLASSNAME, this.rootPath, this.port, this.configuration);
                this.server.start();
                LOGGER.info("WebSocket Registered apps: URLs all start with ws://" + this.hostName + ":" + this.port);
                LOGGER.info("WebSocket server started.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
            LOGGER.info("Websocket Server stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Please provide: (<hostname>, <port>, <websockets root path>, <;-sep fully qualfied classnames of your bean>) in the command line");
            System.out.println("e.g. localhost 8021 /websockets/myapp myapp.Bean1;myapp.Bean2");
            System.exit(1);
        }
        Set<Class<?>> beanClasses = Server.getClassesFromString(args[3]);
        int port = Integer.parseInt(args[1]);
        String hostname = args[0];
        String wsroot = args[2];
        Server server = new Server(hostname, port, wsroot, beanClasses);
        try {
            server.start();
            System.out.println("Press any key to stop the WebSocket server...");
            System.in.read();
        }
        catch (IOException ioe) {
            System.err.println("IOException during server run");
            ioe.printStackTrace();
        }
        finally {
            server.stop();
        }
    }

    private static Set<Class<?>> getClassesFromString(String rawString) {
        HashSet beanClasses = new HashSet();
        StringTokenizer st = new StringTokenizer(rawString, ";");
        while (st.hasMoreTokens()) {
            String nextClassname = st.nextToken().trim();
            if ("".equals(nextClassname)) continue;
            try {
                beanClasses.add(Class.forName(nextClassname));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Stop: cannot load class: " + nextClassname);
            }
        }
        return beanClasses;
    }
}

