/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.util.List;
import java.util.Set;
import javax.net.websocket.Endpoint;
import javax.net.websocket.ServerEndpointConfiguration;

public interface ServerConfiguration {
    public Set<Class<?>> getEndpointClasses();

    public Set<EndpointWithConfiguration> getEndpointInstances();

    public long getMaxSessionIdleTimeout();

    public long getMaxBinaryMessageBufferSize();

    public long getMaxTextMessageBufferSize();

    public List<String> getExtensions();

    public static final class EndpointWithConfiguration {
        private final Endpoint endpoint;
        private final ServerEndpointConfiguration configuration;

        public EndpointWithConfiguration(Endpoint endpoint, ServerEndpointConfiguration configuration) {
            this.endpoint = endpoint;
            this.configuration = configuration;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public ServerEndpointConfiguration getConfiguration() {
            return this.configuration;
        }

        public int hashCode() {
            return this.endpoint.hashCode() + 37 * this.configuration.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EndpointWithConfiguration)) {
                return false;
            }
            EndpointWithConfiguration other = (EndpointWithConfiguration)obj;
            return this.endpoint.equals(other.endpoint) && this.configuration.equals(other.configuration);
        }
    }
}

